<?php         
/**
 * A unique identifier is defined to store the options in the database and reference them from the theme.
 * By default it uses the theme name, in lowercase and without spaces, but this can be changed if needed.
 * If the identifier changes, it'll appear as if the options have been reset.
 */ 

function optionsframework_option_name() {
	// Change this to use your theme slug
	$themename = wp_get_theme();
	$themename = preg_replace("/\W/", "_", strtolower($themename) );
	return $themename;
}

/**
 * Defines an array of options that will be used to generate the settings page and be saved in the database.
 * When creating the 'id' fields, make sure to use all lowercase and no spaces.
 *
 * If you are making your theme translatable, you should replace 'groceem-pro'
 * with the actual text domain for your theme.  Read more:
 * http://codex.wordpress.org/Function_Reference/load_theme_textdomain
*/

function optionsframework_options() {
	//array of all custom font types.
	$font_types = array( '' => '',
    'ABeeZee' => 'ABeeZee',
    'Abel' => 'Abel',
    'Abril Fatface' => 'Abril Fatface',
    'Aclonica' => 'Aclonica',
    'Acme' => 'Acme',
    'Actor' => 'Actor',
    'Adamina' => 'Adamina',
    'Advent Pro' => 'Advent Pro',
    'Aguafina Script' => 'Aguafina Script',
    'Akronim' => 'Akronim',
    'Aladin' => 'Aladin',
    'Aldrich' => 'Aldrich',
    'Alegreya' => 'Alegreya',
    'Alegreya Sans SC' => 'Alegreya Sans SC',
    'Alegreya SC' => 'Alegreya SC',
    'Alex Brush' => 'Alex Brush',
    'Alef' => 'Alef',
    'Alfa Slab One' => 'Alfa Slab One',
    'Alice' => 'Alice',
    'Alike' => 'Alike',
    'Alike Angular' => 'Alike Angular',
    'Allan' => 'Allan',
    'Allerta' => 'Allerta',
    'Allerta Stencil' => 'Allerta Stencil',
    'Allura' => 'Allura',
    'Almendra' => 'Almendra',
    'Almendra Display' => 'Almendra Display',
    'Almendra SC' => 'Almendra SC',
    'Amiri' => 'Amiri',
    'Amarante' => 'Amarante',
    'Amaranth' => 'Amaranth',
    'Amatic SC' => 'Amatic SC',
    'Amethysta' => 'Amethysta',
    'Amita' => 'Amita',
    'Anaheim' => 'Anaheim',
    'Andada' => 'Andada',
    'Andika' => 'Andika',
    'Annie Use Your Telescope' => 'Annie Use Your Telescope',
    'Anonymous Pro' => 'Anonymous Pro',
    'Antic' => 'Antic',
    'Antic Didone' => 'Antic Didone',
    'Antic Slab' => 'Antic Slab',
    'Anton' => 'Anton',
    'Angkor' => 'Angkor',
    'Arapey' => 'Arapey',
    'Arbutus' => 'Arbutus',
    'Arbutus Slab' => 'Arbutus Slab',
    'Architects Daughter' => 'Architects Daughter',
    'Archivo White' => 'Archivo White',
    'Archivo Narrow' => 'Archivo Narrow',
    'Arial' => 'Arial',
    'Arimo' => 'Arimo',
    'Arya' => 'Arya',
    'Arizonia' => 'Arizonia',
    'Armata' => 'Armata',
    'Artifika' => 'Artifika',
    'Arvo' => 'Arvo',
    'Asar' => 'Asar',
    'Asap' => 'Asap',
    'Asset' => 'Asset',
	'Assistant' => 'Assistant',
    'Astloch' => 'Astloch',
    'Asul' => 'Asul',
    'Atomic Age' => 'Atomic Age',
    'Aubrey' => 'Aubrey',
    'Audiowide' => 'Audiowide',
    'Autour One' => 'Autour One',
    'Average' => 'Average',
    'Average Sans' => 'Average Sans',
    'Averia Gruesa Libre' => 'Averia Gruesa Libre',
    'Averia Libre' => 'Averia Libre',
    'Averia Sans Libre' => 'Averia Sans Libre',
    'Averia Serif Libre' => 'Averia Serif Libre',
    'Battambang' => 'Battambang',
    'Bad Script' => 'Bad Script',
    'Bayon' => 'Bayon',
    'Balthazar' => 'Balthazar',
    'Bangers' => 'Bangers',
    'Basic' => 'Basic',
    'Baumans' => 'Baumans',
	'Big Shoulders Text' => 'Big Shoulders Text',
    'Belgrano' => 'Belgrano',
    'Belleza' => 'Belleza',
    'BenchNine' => 'BenchNine',
    'Bentham' => 'Bentham',
    'Berkshire Swash' => 'Berkshire Swash',
    'Bevan' => 'Bevan',
    'Bigelow Rules' => 'Bigelow Rules',
    'Bigshot One' => 'Bigshot One',
    'Bilbo' => 'Bilbo',
    'Bilbo Swash Caps' => 'Bilbo Swash Caps',
    'Biryani' => 'Biryani',
    'Bitter' => 'Bitter',
    'Black Ops One' => 'Black Ops One',
    'Bokor' => 'Bokor',
    'Bonbon' => 'Bonbon',
    'Boogaloo' => 'Boogaloo',
    'Bowlby One' => 'Bowlby One',
    'Bowlby One SC' => 'Bowlby One SC',
    'Brawler' => 'Brawler',
    'Bree Serif' => 'Bree Serif',
    'Bubblegum Sans' => 'Bubblegum Sans',
    'Bubbler One' => 'Bubbler One',
    'Buda' => 'Buda',
    'Buenard' => 'Buenard',
    'Butcherman' => 'Butcherman',
    'Butcherman Caps' => 'Butcherman Caps',
    'Butterfly Kids' => 'Butterfly Kids',
    'Cabin' => 'Cabin',
    'Cabin Condensed' => 'Cabin Condensed',
    'Cabin Sketch' => 'Cabin Sketch',
    'Cabin' => 'Cabin',
    'Caesar Dressing' => 'Caesar Dressing',
    'Cagliostro' => 'Cagliostro',
    'Calligraffitti' => 'Calligraffitti',
    'Cambay' => 'Cambay',
    'Cambo' => 'Cambo',
    'Candal' => 'Candal',
    'Cantarell' => 'Cantarell',
    'Cantata One' => 'Cantata One',
    'Cantora One' => 'Cantora One',
    'Capriola' => 'Capriola',
    'Cardo' => 'Cardo',
    'Carme' => 'Carme',
    'Carrois Gothic' => 'Carrois Gothic',
    'Carrois Gothic SC' => 'Carrois Gothic SC',
    'Carter One' => 'Carter One',
    'Caveat' => 'Caveat',
    'Caveat Brush' => 'Caveat Brush',
    'Catamaran' => 'Catamaran',
    'Caudex' => 'Caudex',
    'Cedarville Cursive' => 'Cedarville Cursive',
    'Ceviche One' => 'Ceviche One',
    'Changa One' => 'Changa One',
    'Chango' => 'Chango',
    'Chau Philomene One' => 'Chau Philomene One',
    'Chenla' => 'Chenla',
    'Chela One' => 'Chela One',
    'Chelsea Market' => 'Chelsea Market',
    'Cherry Cream Soda' => 'Cherry Cream Soda',
    'Cherry Swash' => 'Cherry Swash',
    'Chewy' => 'Chewy',
    'Chicle' => 'Chicle',
    'Chivo' => 'Chivo',
    'Chonburi' => 'Chonburi',
    'Cinzel' => 'Cinzel',
    'Cinzel Decorative' => 'Cinzel Decorative',
    'Clicker Script' => 'Clicker Script',
    'Coda' => 'Coda',
    'Codystar' => 'Codystar',
    'Combo' => 'Combo',
    'Comfortaa' => 'Comfortaa',
    'Coming Soon' => 'Coming Soon',
    'Condiment' => 'Condiment',
    'Content' => 'Content',
    'Contrail One' => 'Contrail One',
    'Convergence' => 'Convergence',
    'Cookie' => 'Cookie',
    'Comic Sans MS' => 'Comic Sans MS',
    'Copse' => 'Copse',
    'Corben' => 'Corben',
    'Courgette' => 'Courgette',
    'Cousine' => 'Cousine',
    'Coustard' => 'Coustard',
    'Covered By Your Grace' => 'Covered By Your Grace',
    'Crafty Girls' => 'Crafty Girls',
    'Creepster' => 'Creepster',
    'Creepster Caps' => 'Creepster Caps',
    'Crete Round' => 'Crete Round',
    'Crimson' => 'Crimson',
    'Croissant One' => 'Croissant One',
    'Crushed' => 'Crushed',
    'Cuprum' => 'Cuprum',
    'Cutive' => 'Cutive',
    'Cutive Mono' => 'Cutive Mono',
    'Damion' => 'Damion',
    'Dangrek' => 'Dangrek',
    'Dancing Script' => 'Dancing Script',
    'Dawning of a New Day' => 'Dawning of a New Day',
    'Days One' => 'Days One',
    'Dekko' => 'Dekko',
    'Delius' => 'Delius',
    'Delius Swash Caps' => 'Delius Swash Caps',
    'Delius Unicase' => 'Delius Unicase',
    'Della Respira' => 'Della Respira',
    'Denk One' => 'Denk One',
    'Devonshire' => 'Devonshire',
    'Dhurjati' => 'Dhurjati',
    'Didact Gothic' => 'Didact Gothic',
    'Diplomata' => 'Diplomata',
    'Diplomata SC' => 'Diplomata SC',
    'Domine' => 'Domine',
    'Donegal One' => 'Donegal One',
    'Doppio One' => 'Doppio One',
    'Dorsa' => 'Dorsa',
    'Dosis' => 'Dosis',
    'Dr Sugiyama' => 'Dr Sugiyama',
    'Droid Sans' => 'Droid Sans',
    'Droid Sans Mono' => 'Droid Sans Mono',
    'Droid Serif' => 'Droid Serif',
    'Duru Sans' => 'Duru Sans',
    'Dynalight' => 'Dynalight',
    'EB Garamond' => 'EB Garamond',
    'Eczar' => 'Eczar',
    'Eagle Lake' => 'Eagle Lake',
    'Eater' => 'Eater',
    'Eater Caps' => 'Eater Caps',
    'Economica' => 'Economica',
    'Ek Mukta' => 'Ek Mukta',
    'Electrolize' => 'Electrolize',
    'Elsie' => 'Elsie',
    'Elsie Swash Caps' => 'Elsie Swash Caps',
    'Emblema One' => 'Emblema One',
    'Emilys Candy' => 'Emilys Candy',
    'Engagement' => 'Engagement',
    'Englebert' => 'Englebert',
    'Enriqueta' => 'Enriqueta',
    'Erica One' => 'Erica One',
    'Esteban' => 'Esteban',
    'Euphoria Script' => 'Euphoria Script',
    'Ewert' => 'Ewert',
    'Exo' => 'Exo',
    'Exo 2' => 'Exo 2',
    'Expletus Sans' => 'Expletus Sans',
    'Fanwood Text' => 'Fanwood Text',
    'Fascinate' => 'Fascinate',
    'Fascinate Inline' => 'Fascinate Inline',
    'Fasthand' => 'Fasthand',
    'Faster One' => 'Faster One',
    'Federant' => 'Federant',
    'Federo' => 'Federo',
    'Felipa' => 'Felipa',
    'Fenix' => 'Fenix',
    'Finger Paint' => 'Finger Paint',
    'Fira Mono' => 'Fira Mono',
    'Fira Sans' => 'Fira Sans',
    'Fjalla One' => 'Fjalla One',
    'Fjord One' => 'Fjord One',
    'Flamenco' => 'Flamenco',
    'Flavors' => 'Flavors',
    'Fondamento' => 'Fondamento',
    'Fontdiner Swanky' => 'Fontdiner Swanky',
    'Forum' => 'Forum',
    'Francois One' => 'Francois One',
    'FreeSans' => 'FreeSans',

    'Freckle Face' => 'Freckle Face',
    'Fredericka the Great' => 'Fredericka the Great',
    'Fredoka One' => 'Fredoka One',
    'Fresca' => 'Fresca',
    'Freehand' => 'Freehand',
    'Frijole' => 'Frijole',
    'Fruktur' => 'Fruktur',
    'Fugaz One' => 'Fugaz One',
    'Gafata' => 'Gafata',
    'Galdeano' => 'Galdeano',
    'Galindo' => 'Galindo',
    'Gentium Basic' => 'Gentium Basic',
    'Gentium Book Basic' => 'Gentium Book Basic',
    'Geo' => 'Geo',
    'Georgia' => 'Georgia',
    'Geostar' => 'Geostar',
    'Geostar Fill' => 'Geostar Fill',
    'Germania One' => 'Germania One',
    'Gilda Display' => 'Gilda Display',
    'Give You Glory' => 'Give You Glory',
    'Glass Antiqua' => 'Glass Antiqua',
    'Glegoo' => 'Glegoo',
    'Gloria Hallelujah' => 'Gloria Hallelujah',
    'Goblin One' => 'Goblin One',
    'Gochi Hand' => 'Gochi Hand',
    'Gorditas' => 'Gorditas',
    'Gurajada' => 'Gurajada',
    'Goudy Bookletter 1911' => 'Goudy Bookletter 1911',
    'Graduate' => 'Graduate',
    'Grand Hotel' => 'Grand Hotel',
    'Gravitas One' => 'Gravitas One',
    'Great Vibes' => 'Great Vibes',
    'Griffy' => 'Griffy',
    'Gruppo' => 'Gruppo',
    'Gudea' => 'Gudea',
    'Gidugu' => 'Gidugu',
    'GFS Didot' => 'GFS Didot',
    'GFS Neohellenic' => 'GFS Neohellenic',
    'Habibi' => 'Habibi',
    'Hammersmith One' => 'Hammersmith One',
    'Halant' => 'Halant',
    'Hanalei' => 'Hanalei',
    'Hanalei Fill' => 'Hanalei Fill',
    'Handlee' => 'Handlee',
    'Hanuman' => 'Hanuman',
    'Happy Monkey' => 'Happy Monkey',
    'Headland One' => 'Headland One',
    'Henny Penny' => 'Henny Penny',
    'Herr Von Muellerhoff' => 'Herr Von Muellerhoff',
    'Hind' => 'Hind',
    'Hind Siliguri' => 'Hind Siliguri',
    'Hind Vadodara' => 'Hind Vadodara',
    'Holtwood One SC' => 'Holtwood One SC',
    'Homemade Apple' => 'Homemade Apple',
    'Homenaje' => 'Homenaje',
    'IM Fell' => 'IM Fell',
    'Itim' => 'Itim',
    'Iceberg' => 'Iceberg',
    'Iceland' => 'Iceland',
    'Imprima' => 'Imprima',
    'Inconsolata' => 'Inconsolata',
    'Inder' => 'Inder',
    'Indie Flower' => 'Indie Flower',
    'Inknut Antiqua' => 'Inknut Antiqua',
    'Inika' => 'Inika',
    'Irish Growler' => 'Irish Growler',
    'Istok Web' => 'Istok Web',
    'Italiana' => 'Italiana',
    'Italianno' => 'Italianno',
    'Jacques Francois' => 'Jacques Francois',
    'Jacques Francois Shadow' => 'Jacques Francois Shadow',
    'Jim Nightshade' => 'Jim Nightshade',
    'Jockey One' => 'Jockey One',
    'Jaldi' => 'Jaldi',
    'Jolly Lodger' => 'Jolly Lodger',
    'Josefin Sans' => 'Josefin Sans',
    'Josefin Sans' => 'Josefin Sans',
    'Josefin Slab' => 'Josefin Slab',
    'Joti One' => 'Joti One',
    'Judson' => 'Judson',
    'Julee' => 'Julee',
    'Julius Sans One' => 'Julius Sans One',
    'Junge' => 'Junge',
    'Jura' => 'Jura',
    'Just Another Hand' => 'Just Another Hand',
    'Just Me Again Down Here' => 'Just Me Again Down Here',
    'Kadwa' => 'Kadwa',
    'Kdam Thmor' => 'Kdam Thmor',
    'Kalam' => 'Kalam', 
    'Kameron' => 'Kameron',
    'Kantumruy' => 'Kantumruy',
    'Karma' => 'Karma',
    'Karla' => 'Karla',
    'Kaushan Script' => 'Kaushan Script',
    'Kavoon' => 'Kavoon',
    'Keania One' => 'Keania One',
    'Kelly Slab' => 'Kelly Slab',
    'Kenia' => 'Kenia',
    'Khand' => 'Khand',
    'Khmer' => 'Khmer',
    'Khula' => 'Khula',
    'Kite One' => 'Kite One',
    'Knewave' => 'Knewave',
    'Kotta One' => 'Kotta One',
    'Kranky' => 'Kranky',
    'Kreon' => 'Kreon',
    'Kristi' => 'Kristi',
    'Koulen' => 'Koulen',
    'Krona One' => 'Krona One',
    'Kurale' => 'Kurale',
    'Lakki Reddy' => 'Lakki Reddy',
    'La Belle Aurore' => 'La Belle Aurore',
    'Lancelot' => 'Lancelot',
    'Laila' => 'Laila',
    'Lato' => 'Lato',
    'Lateef' => 'Lateef',
    'League Script' => 'League Script',
    'Leckerli One' => 'Leckerli One',
    'Ledger' => 'Ledger',
    'Lekton' => 'Lekton',
    'Lemon' => 'Lemon',
    'Libre Baskerville' => 'Libre Baskerville',
    'Life Savers' => 'Life Savers',
    'Lilita One' => 'Lilita One',
    'Limelight' => 'Limelight',
    'Linden Hill' => 'Linden Hill',
    'Lobster' => 'Lobster',
    'Lobster Two' => 'Lobster Two',
    'Londrina Outline' => 'Londrina Outline',
    'Londrina Shadow' => 'Londrina Shadow',
    'Londrina Sketch' => 'Londrina Sketch',
    'Londrina Solid' => 'Londrina Solid',
    'Lora' => 'Lora',
    'Love Ya Like A Sister' => 'Love Ya Like A Sister',
    'Loved by the King' => 'Loved by the King',
    'Lovers Quarrel' => 'Lovers Quarrel',
    'Lucida Sans Unicode' => 'Lucida Sans Unicode',
    'Luckiest Guy' => 'Luckiest Guy',
    'Lusitana' => 'Lusitana',
    'Lustria' => 'Lustria',
    'Macondo' => 'Macondo',
    'Macondo Swash Caps' => 'Macondo Swash Caps',
    'Magra' => 'Magra',
    'Maiden Orange' => 'Maiden Orange',
    'Mallanna' => 'Mallanna',
    'Mandali' => 'Mandali',
    'Mako' => 'Mako',
    'Marcellus' => 'Marcellus',
    'Marcellus SC' => 'Marcellus SC',
    'Marck Script' => 'Marck Script',
    'Margarine' => 'Margarine',
    'Marko One' => 'Marko One',
    'Marmelad' => 'Marmelad',
    'Marvel' => 'Marvel',
    'Martel' => 'Martel',
    'Martel Sans' => 'Martel Sans',
    'Mate' => 'Mate',
    'Mate SC' => 'Mate SC',
    'Maven Pro' => 'Maven Pro',
    'McLaren' => 'McLaren',
    'Meddon' => 'Meddon',
    'MedievalSharp' => 'MedievalSharp',
    'Medula One' => 'Medula One',
    'Megrim' => 'Megrim',
    'Meie Script' => 'Meie Script',
    'Merienda' => 'Merienda',
    'Merienda One' => 'Merienda One',
    'Merriweather' => 'Merriweather',
    'Metal' => 'Metal',
    'Metal Mania' => 'Metal Mania',
    'Metamorphous' => 'Metamorphous',
    'Metrophobic' => 'Metrophobic',
    'Michroma' => 'Michroma',
    'Milonga' => 'Milonga',
    'Miltonian' => 'Miltonian',
    'Miltonian Tattoo' => 'Miltonian Tattoo',
    'Miniver' => 'Miniver',
    'Miss Fajardose' => 'Miss Fajardose',
    'Miss Saint Delafield' => 'Miss Saint Delafield',
    'Modak' => 'Modak',
    'Modern Antiqua' => 'Modern Antiqua',
    'Molengo' => 'Molengo',
    'Molle' => 'Molle',
    'Moulpali' => 'Moulpali',
    'Monda' => 'Monda',
    'Monofett' => 'Monofett',
    'Monoton' => 'Monoton',
    'Monsieur La Doulaise' => 'Monsieur La Doulaise',
    'Montaga' => 'Montaga',
    'Montez' => 'Montez',
    'Montserrat' => 'Montserrat',
    'Montserrat Alternates' => 'Montserrat Alternates',
    'Montserrat Subrayada' => 'Montserrat Subrayada',
    'Mountains of Christmas' => 'Mountains of Christmas',
    'Mouse Memoirs' => 'Mouse Memoirs',
    'Moul' => 'Moul',
    'Mr Bedford' => 'Mr Bedford',
    'Mr Bedfort' => 'Mr Bedfort',
    'Mr Dafoe' => 'Mr Dafoe',
    'Mr De Haviland' => 'Mr De Haviland',
    'Mrs Saint Delafield' => 'Mrs Saint Delafield',
    'Mrs Sheppards' => 'Mrs Sheppards',
    'Muli' => 'Muli',
    'Mystery Quest' => 'Mystery Quest',
    'Neucha' => 'Neucha',
    'Neuton' => 'Neuton',
    'New Rocker' => 'New Rocker',
    'News Cycle' => 'News Cycle',
    'Niconne' => 'Niconne',
    'Nixie One' => 'Nixie One',
    'Nobile' => 'Nobile',
    'Nokora' => 'Nokora',
    'Norican' => 'Norican',
    'Nosifer' => 'Nosifer',
    'Nosifer Caps' => 'Nosifer Caps',
    'Nova Mono' => 'Nova Mono',
    'Noticia Text' => 'Noticia Text',
    'Noto Sans' => 'Noto Sans',
    'Noto Serif' => 'Noto Serif',
    'Nova Round' => 'Nova Round',
    'Numans' => 'Numans',
    'Nunito' => 'Nunito',
    'NTR' => 'NTR',
    'Offside' => 'Offside',
    'Oldenburg' => 'Oldenburg',
    'Oleo Script' => 'Oleo Script',
    'Oleo Script Swash Caps' => 'Oleo Script Swash Caps',
    'Open Sans' => 'Open Sans',
    'Open Sans Condensed' => 'Open Sans Condensed',
    'Oranienbaum' => 'Oranienbaum',
    'Orbitron' => 'Orbitron',
    'Odor Mean Chey' => 'Odor Mean Chey',
    'Oregano' => 'Oregano',
    'Orienta' => 'Orienta',
    'Original Surfer' => 'Original Surfer',
    'Oswald' => 'Oswald',
    'Over the Rainbow' => 'Over the Rainbow',
    'Overlock' => 'Overlock',
    'Overlock SC' => 'Overlock SC',
    'Ovo' => 'Ovo',
    'Oxygen' => 'Oxygen',
    'Oxygen Mono' => 'Oxygen Mono',
    'Palanquin Dark' => 'Palanquin Dark',
    'Peddana' => 'Peddana',
    'Poppins' => 'Poppins',
    'PT Mono' => 'PT Mono',
    'PT Sans' => 'PT Sans',
    'PT Sans Caption' => 'PT Sans Caption',
    'PT Sans Narrow' => 'PT Sans Narrow',
    'PT Serif' => 'PT Serif',
    'PT Serif Caption' => 'PT Serif Caption',
    'Pacifico' => 'Pacifico',
    'Paprika' => 'Paprika',
    'Parisienne' => 'Parisienne',
    'Passero One' => 'Passero One',
    'Passion One' => 'Passion One',
    'Patrick Hand' => 'Patrick Hand',
    'Patrick Hand SC' => 'Patrick Hand SC',
    'Patua One' => 'Patua One',
    'Paytone One' => 'Paytone One',
    'Peralta' => 'Peralta',
    'Permanent Marker' => 'Permanent Marker',
    'Petit Formal Script' => 'Petit Formal Script',
    'Petrona' => 'Petrona',
    'Philosopher' => 'Philosopher',
    'Piedra' => 'Piedra',
    'Pinyon Script' => 'Pinyon Script',
    'Pirata One' => 'Pirata One',
    'Plaster' => 'Plaster',
    'Palatino Linotype' => 'Palatino Linotype',
    'Play' => 'Play',
    'Playball' => 'Playball',
    'Playfair Display' => 'Playfair Display',
    'Playfair Display SC' => 'Playfair Display SC',
    'Podkova' => 'Podkova',
    'Poiret One' => 'Poiret One',
    'Poller One' => 'Poller One',
    'Poly' => 'Poly',
    'Pompiere' => 'Pompiere',
    'Pontano Sans' => 'Pontano Sans',
    'Port Lligat Sans' => 'Port Lligat Sans',
    'Port Lligat Slab' => 'Port Lligat Slab',
    'Prata' => 'Prata',
    'Pragati Narrow' => 'Pragati Narrow',
    'Preahvihear' => 'Preahvihear',
    'Press Start 2P' => 'Press Start 2P',
    'Princess Sofia' => 'Princess Sofia',
    'Prociono' => 'Prociono',
    'Prosto One' => 'Prosto One',
    'Puritan' => 'Puritan',
    'Purple Purse' => 'Purple Purse',
    'Quando' => 'Quando',
    'Quantico' => 'Quantico',
    'Quattrocento' => 'Quattrocento',
    'Quattrocento Sans' => 'Quattrocento Sans',
    'Questrial' => 'Questrial',
    'Quicksand' => 'Quicksand',
    'Quintessential' => 'Quintessential',
    'Qwigley' => 'Qwigley',
    'Racing Sans One' => 'Racing Sans One',
    'Radley' => 'Radley',
    'Rajdhani' => 'Rajdhani',
    'Raleway Dots' => 'Raleway Dots',
    'Raleway' => 'Raleway',
    'Rambla' => 'Rambla',
    'Ramabhadra' => 'Ramabhadra',
    'Ramaraja' => 'Ramaraja',
    'Rammetto One' => 'Rammetto One',
    'Ranchers' => 'Ranchers',
    'Rancho' => 'Rancho',
    'Ranga' => 'Ranga',
    'Ravi Prakash' => 'Ravi Prakash',
    'Rationale' => 'Rationale',
    'Redressed' => 'Redressed',
    'Reenie Beanie' => 'Reenie Beanie',
    'Revalia' => 'Revalia',
    'Rhodium Libre' => 'Rhodium Libre',
    'Ribeye' => 'Ribeye',
    'Ribeye Marrow' => 'Ribeye Marrow',
    'Righteous' => 'Righteous',
    'Risque' => 'Risque',
    'Roboto' => 'Roboto',
    'Roboto Condensed' => 'Roboto Condensed',
    'Roboto Mono' => 'Roboto Mono',
    'Roboto Slab' => 'Roboto Slab',
    'Rochester' => 'Rochester',
    'Rock Salt' => 'Rock Salt',
    'Rokkitt' => 'Rokkitt',
    'Romanesco' => 'Romanesco',
    'Ropa Sans' => 'Ropa Sans',
    'Rosario' => 'Rosario',
    'Rosarivo' => 'Rosarivo',
    'Rouge Script' => 'Rouge Script',
    'Rozha One' => 'Rozha One',
    'Rubik' => 'Rubik',
    'Rubik One' => 'Rubik One',
    'Rubik Mono One' => 'Rubik Mono One',
    'Ruda' => 'Ruda',
    'Rufina' => 'Rufina',
    'Ruge Boogie' => 'Ruge Boogie',
    'Ruluko' => 'Ruluko',
    'Rum Raisin' => 'Rum Raisin',
    'Ruslan Display' => 'Ruslan Display',
    'Russo One' => 'Russo One',
    'Ruthie' => 'Ruthie',
    'Rye' => 'Rye',
    'Sacramento' => 'Sacramento',
    'Sail' => 'Sail',
    'Salsa' => 'Salsa',
    'Sanchez' => 'Sanchez',
    'Sancreek' => 'Sancreek',
    'Sahitya' => 'Sahitya',
    'Sansita One' => 'Sansita One',
    'Sarpanch' => 'Sarpanch',
    'Sarina' => 'Sarina',
    'Satisfy' => 'Satisfy',
    'Scada' => 'Scada',
    'Scheherazade' => 'Scheherazade',
    'Schoolbell' => 'Schoolbell',
    'Seaweed Script' => 'Seaweed Script',
    'Sarala' => 'Sarala',
    'Sevillana' => 'Sevillana',
    'Seymour One' => 'Seymour One',
    'Shadows Into Light' => 'Shadows Into Light',
    'Shadows Into Light Two' => 'Shadows Into Light Two',
    'Shanti' => 'Shanti',
    'Share' => 'Share',
    'Share Tech' => 'Share Tech',
    'Share Tech Mono' => 'Share Tech Mono',
    'Shojumaru' => 'Shojumaru',
    'Short Stack' => 'Short Stack',
    'Sigmar One' => 'Sigmar One',
    'Suranna' => 'Suranna',
    'Suravaram' => 'Suravaram',
    'Suwannaphum' => 'Suwannaphum',
    'Signika' => 'Signika',
    'Signika Negative' => 'Signika Negative',
    'Simonetta' => 'Simonetta',
    'Siemreap' => 'Siemreap',
    'Sirin Stencil' => 'Sirin Stencil',
    'Six Caps' => 'Six Caps',
    'Skranji' => 'Skranji',
    'Slackey' => 'Slackey',
    'Smokum' => 'Smokum',
    'Smythe' => 'Smythe',
    'Sniglet' => 'Sniglet',
    'Snippet' => 'Snippet',
    'Snowburst One' => 'Snowburst One',
    'Sofadi One' => 'Sofadi One',
    'Sofia' => 'Sofia',
    'Sonsie One' => 'Sonsie One',
    'Sorts Mill Goudy' => 'Sorts Mill Goudy',
    'Sorts Mill Goudy' => 'Sorts Mill Goudy',
    'Source Code Pro' => 'Source Code Pro',
    'Source Sans Pro' => 'Source Sans Pro',
    'Special I am one' => 'Special I am one',
    'Spicy Rice' => 'Spicy Rice',
    'Spinnaker' => 'Spinnaker',
    'Spirax' => 'Spirax',
    'Squada One' => 'Squada One',
    'Sree Krushnadevaraya' => 'Sree Krushnadevaraya',
    'Stalemate' => 'Stalemate',
    'Stalinist One' => 'Stalinist One',
    'Stardos Stencil' => 'Stardos Stencil',
    'Stint Ultra Condensed' => 'Stint Ultra Condensed',
    'Stint Ultra Expanded' => 'Stint Ultra Expanded',
    'Stoke' => 'Stoke',
    'Stoke' => 'Stoke',
    'Strait' => 'Strait',
    'Sura' => 'Sura',
    'Sumana' => 'Sumana',
    'Sue Ellen Francisco' => 'Sue Ellen Francisco',
    'Sunshiney' => 'Sunshiney',
    'Supermercado One' => 'Supermercado One',
    'Swanky and Moo Moo' => 'Swanky and Moo Moo',
    'Syncopate' => 'Syncopate',
    'Symbol' => 'Symbol',
    'Timmana' => 'Timmana',
    'Taprom' => 'Taprom',
    'Tangerine' => 'Tangerine',
    'Tahoma' => 'Tahoma',
    'Teko' => 'Teko',
    'Telex' => 'Telex',
    'Tenali Ramakrishna' => 'Tenali Ramakrishna',
    'Tenor Sans' => 'Tenor Sans',
    'Terminal Dosis' => 'Terminal Dosis',
    'Terminal Dosis Light' => 'Terminal Dosis Light',
    'Text Me One' => 'Text Me One',
    'The Girl Next Door' => 'The Girl Next Door',
    'Tienne' => 'Tienne',
    'Tillana' => 'Tillana',
    'Tinos' => 'Tinos',
    'Titan One' => 'Titan One',
    'Titillium Web' => 'Titillium Web',
    'Trade Winds' => 'Trade Winds',
    'Trebuchet MS' => 'Trebuchet MS',
    'Trocchi' => 'Trocchi',
    'Trochut' => 'Trochut',
    'Trykker' => 'Trykker',
    'Tulpen One' => 'Tulpen One',
    'Ubuntu' => 'Ubuntu',
    'Ubuntu Condensed' => 'Ubuntu Condensed',
    'Ubuntu Mono' => 'Ubuntu Mono',
    'Ultra' => 'Ultra',
    'Uncial Antiqua' => 'Uncial Antiqua',
    'Underdog' => 'Underdog',
    'Unica One' => 'Unica One',
    'UnifrakturCook' => 'UnifrakturCook',
    'UnifrakturMaguntia' => 'UnifrakturMaguntia',
    'Unkempt' => 'Unkempt',
    'Unlock' => 'Unlock',
    'Unna' => 'Unna',
    'VT323' => 'VT323',
    'Vampiro One' => 'Vampiro One',
    'Varela' => 'Varela',
    'Varela Round' => 'Varela Round',
    'Vast Shadow' => 'Vast Shadow',
    'Vesper Libre' => 'Vesper Libre',
    'Verdana' => 'Verdana',
    'Vibur' => 'Vibur',
    'Vidaloka' => 'Vidaloka',
    'Viga' => 'Viga',
    'Voces' => 'Voces',
    'Volkhov' => 'Volkhov',
    'Vollkorn' => 'Vollkorn',
    'Voltaire' => 'Voltaire',
    'Waiting for the Sunrise' => 'Waiting for the Sunrise',
    'Wallpoet' => 'Wallpoet',
    'Walter Turncoat' => 'Walter Turncoat',
    'Warnes' => 'Warnes',
    'Wellfleet' => 'Wellfleet',
    'Wendy One' => 'Wendy One',
    'Wire One' => 'Wire One',
    'Yanone Kaffeesatz' => 'Yanone Kaffeesatz',
    'Yantramanav' => 'Yantramanav',
    'Yellowtail' => 'Yellowtail',
    'Yeseva One' => 'Yeseva One',
    'Yesteryear' => 'Yesteryear',
    'Zeyada' => 'Zeyada'
  );

	//array of all font sizes.
	$font_sizes = array( 
		'10px' => '10px',
		'11px' => '11px',
	);
	
	$options = array();
	$imagepath =  get_template_directory_uri() . '/images/';

	
	for($n=12;$n<=200;$n+=1){
		$font_sizes[$n.'px'] = $n.'px';
	}
	
	// Pull all the pages into an array
	 $options_pages = array();
	 $options_pages_obj = get_pages('sort_column=post_parent,menu_order');
	 $options_pages[''] = 'Select a page:';
	 foreach ($options_pages_obj as $page) {
	  $options_pages[$page->ID] = $page->post_title;
	 }

	// array of section content.
	$section_text = array(	
		1 => array(
			'section_title'	=> '',
			'section_sub_title'	=> '',
			'menutitle'		=> 'section1',
			'titlecolor'	=> '#292929',
			'bgcolor' 		=> '#f9f9f9',
			'bgimage'		=> '',
			'class'			=> 'section_shadow',
			'content'		=> '[column_content type="left-column-40"][our-mission-image image="'.get_template_directory_uri().'/images/providing-high-quality-image.png"][/column_content][column_content type="right-column-55"][section-main-title title="Providing High Quality Healthy and Natural Products" subtitle="Welcome to Groceem" color="#343434"][subtitle color="#161616" description="Curabitur ligula enim, pellen sitam etullamcorp molesti viverr Curabitur ligula enim, pellen sitam etullamcorp molesti viverr Sed eleifend porttitor nulla."][our-mission icon="'.get_template_directory_uri().'/images/our-mission-icon-1.png" title="Our Mission" description="Curabitur ligula enim, pellen sitam etullamcorp Curabitur ligula enim, etullamcorp."][our-mission icon="'.get_template_directory_uri().'/images/our-mission-icon-2.png" title="Our Vision" description="Curabitur ligula enim, pellen sitam etullamcorp Curabitur ligula enim, etullamcorp."][/column_content][clear]',
			),

		2 => array(
			'section_title'	=> 'Fresh & Natural Products',
			'section_sub_title'	=> 'Featured Products',
			'menutitle'		=> 'section2',
			'titlecolor'	=> '#343434',
			'bgcolor' 		=> '#f9f9f9',
			'bgimage'		=> '',
			'class'			=> 'area_row',
			'content'		=> '[column_content type="left-column-65"][products limit="6" columns="3" class="our-product"][/column_content][column_content type="right-column-30"][natural-products-image image="'.get_template_directory_uri().'/images/natural-products-image.jpg"][countdown count="1" year="2024" month="12" date="31"][section-main-title title="Orange" color="#252525"][orange-price sellprice="$4.00" regularprice="$8.00"][subtitle color="#161616" description="Curabitur ligula enim, pellen sitam etulla mcorp Curabitur ligula enim."][button name="SHOP NOW" link="#" target="_self"][/column_content][clear]',
			),	

		3 => array(
			'section_title'	=> '',
			'section_sub_title'	=> '',
			'menutitle'		=> 'section3',
			'titlecolor'	=> '#292929',
			'bgcolor' 		=> '#ffffff',
			'bgimage'		=>  get_template_directory_uri().'/images/section3.jpg',
			'class'			=> 'area_row',
			'content'		=> '[column_content type="left-column-50"][section-main-title title="Everyday Fresh & Clean Organic Products" color="#ffffff" subtitle="Looking Organic Food?"][subtitle color="#ffffff" description="Curabitur ligula enim, pellen sitam etullamcorp molesti viverra nonelit Sed eleifend porttitor nulla."][button name="READ MORE" link="#" target="_self"][/column_content][column_content type="right-column-50"][custom-video youtubeid="NXqYgaPRFds"][/column_content][clear]'
			),
		
		4 => array(
			'section_title'	=> '',
			'section_sub_title'	=> '',
			'menutitle'		=> 'section4',
			'titlecolor'	=> '#292929',
			'bgcolor' 		=> '#ffffff',
			'bgimage'		=> '',
			'class'			=> 'area_row',
			'content'		=> '[column_content type="left-column-40"][organic-fresh-image image="'.get_template_directory_uri().'/images/organic-fresh-image.png"][/column_content][column_content type="right-column-55"][section-main-title title="All of our products are organic & fresh" color="#343434"][subtitle color="#161616" description="Curabitur ligula enim, pellen sitam etullamcorp molesti viverra nonelit Sed eleifend porttitor nulla."][organic-fres image="'.get_template_directory_uri().'/images/organic-fresh-1.png" title="Organic Food" description="Curabitur ligulaenim pellen sitam etullamcnulla." readmore="READ MORE" link="#"][organic-fres image="'.get_template_directory_uri().'/images/organic-fresh-2.png" title="Safe & Trusty" description="Best organic farms" readmore="READ MORE" link="#"][/column_content]',
			),		

		5 => array(
			'section_title'	=> 'Flavors from the farm',
			'section_sub_title'	=> 'Bring Freshness',
			'menutitle'		=> 'section5',
			'titlecolor'	=> '#1e1206',
			'bgcolor' 		=> '#ffffff',
			'bgimage'		=> get_template_directory_uri().'/images/section5.jpg',
			'class'			=> 'area_row',
			'content'		=> '[flavors-farm-image image="'.get_template_directory_uri().'/images/Flavors-from-the-farm.png"][services icon="'.get_template_directory_uri().'/images/services-icon-1.png" title="100% Organic" description="Curabitur ligula enipelle etullamcorp moliviverra nonelitd eleifenttitor." link="#"][services icon="'.get_template_directory_uri().'/images/services-icon-2.png" title="Family Healthy" description="Curabitur ligula enipelle etullamcorp moliviverra nonelitd eleifenttitor." link="#"][services icon="'.get_template_directory_uri().'/images/services-icon-3.png" title="Always Fresh" description="Curabitur ligula enipelle etullamcorp moliviverra nonelitd eleifenttitor." link="#"][services icon="'.get_template_directory_uri().'/images/services-icon-4.png" title="Food Safety" description="Curabitur ligula enipelle etullamcorp moliviverra nonelitd eleifenttitor." link="#"]',
		),
		
		6 => array(
			'section_title'	=> '',
			'section_sub_title'	=> '',
			'menutitle'		=> 'section6',
			'titlecolor'	=> '#282828',
			'bgcolor' 		=> '#ffffff',
			'bgimage'		=> '',
			'class'			=> 'area_row',
			'content'		=> '[column_content type="left-column-50"][section-main-title title="We believe in working with accredited farmers" color="#343434"][subtitle color="#161616" description="Morbi ac justo rutrum, euismod diam ut, accumsan lorem. Vestibulum sit amet dolor sem. Aliquam erat volutpat. Suspendisse risus ex, volutpat sit amet ultricies non, consequat sed ante. Integer consectetur felis at metus finibus, ac viverra sapien gravida. Curabitur vel est tellus. Ut elementum vehicula dictum. Aenean justo mauris, ullamcorper nec nulla quis, sodales efficitur ipsum. Etiam pretium nibh ex, ac vehicula odio gravida vitae."]
[custom-video youtubeid="Vagc5qqm1_o" title="Watch Our Video"]
[accredited-farmers image="'.get_template_directory_uri().'/images/accredited-farmers-1.png" title="Professional Farmers"][accredited-farmers image="'.get_template_directory_uri().'/images/accredited-farmers-2.png" title="Organic & Eco Solutions"][clear][button name="DISCOVER MORE" link="#" target="_self"][button name="SEND A MESSAGE" link="#" target="_self"][/column_content][column_content type="right-column-45"][we-believe-farmers-image image_large="'.get_template_directory_uri().'/images/image_large.jpg" image_thumb="'.get_template_directory_uri().'/images/image_thumb.jpg"][/column_content]'
		),
				
		7 => array(
			'section_title'	=> '',
			'section_sub_title'	=> '',
			'menutitle'		=> 'section7',
			'titlecolor'	=> '#000000',
			'bgcolor' 		=> '#ffffff',
			'bgimage'		=> get_template_directory_uri().'/images/section7.jpg',
			'class'			=> 'area_row',
			'content'		=> '[column_content type="left-column-45"][organic-store image="'.get_template_directory_uri().'/images/organic-store-1.png" title="Fresh Pomegranate" discount="30% Discount" shopnow="SHOP NOW" link="#"][organic-store image="'.get_template_directory_uri().'/images/organic-store-2.png" title="Fresh Green Lemon" discount="60% Discount" shopnow="SHOP NOW" link="#"][/column_content][column_content type="right-column-50"][section-main-title title="SUBSCRIBE TO OUR ONLINE ORGANIC STORE!" subtitle="Online Market of Organic Food" color="#ffffff"][subtitle color="#ffffff" description="Morbi ac justo rutrum, euismod diam ut, accumsan lorem. Vestibu lum sit amet dolor sem. Aliquam erat volutpat. Suspendisse risus ex, volutpat sit amet ultricies non"][mc4wp_form id="1796"][/column_content][clear]'
		),
		
		8 => array(
			'section_title'	=> 'What We’re Offering',
			'section_sub_title'	=> '',
			'menutitle'		=> 'section8',
			'titlecolor'	=> '#343434',
			'bgcolor' 		=> '#f6f6f6',
			'bgimage'		=> '',
			'class'			=> 'area_row',
			'content'		=> '[offering-services image="'.get_template_directory_uri().'/images/offering-image-1.jpg" icon="'.get_template_directory_uri().'/images/offering-icon-1.png" title="Organic Products" description="Lorem ium dolor sit ametad pisicing elit sed simply do ut." link="#"][offering-services image="'.get_template_directory_uri().'/images/offering-image-2.jpg" icon="'.get_template_directory_uri().'/images/offering-icon-2.png" title="Dairy Products" description="Lorem ium dolor sit ametad pisicing elit sed simply do ut." link="#"][offering-services image="'.get_template_directory_uri().'/images/offering-image-3.jpg" icon="'.get_template_directory_uri().'/images/offering-icon-3.png" title="Agriculture Products" description="Lorem ium dolor sit ametad pisicing elit sed simply do ut." link="#"][offering-services image="'.get_template_directory_uri().'/images/offering-image-4.jpg" icon="'.get_template_directory_uri().'/images/offering-icon-4.png" title="Fresh Vegetables" description="Lorem ium dolor sit ametad pisicing elit sed simply do ut." link="#"]'
			),	
		
		9 => array(
			'section_title'	=> '',
			'section_sub_title'	=> '',
			'menutitle'		=> 'section9',
			'titlecolor'	=> '#1e1206',
			'bgcolor' 		=> '#fefefe',
			'bgimage'		=> '',
			'class'			=> 'area_row',
			'content'		=> '[column_content type="left-column-50"][section-main-title title="News from the farm" subtitle="Tips & Articles" color="#343434"][/column_content][column_content type="right-column-50"][button name="View All Articles" link="#" target="_self"][/column_content][clear][latest-news showposts="3" date="show" comment="hide" author="hide"]'
		),
		
		
		10 => array(
			'section_title'	=> '',
			'section_sub_title'	=> '',
			'menutitle'		=> 'section10',
			'titlecolor'	=> '#000000',
			'bgcolor' 		=> '#58a740',
			'bgimage'		=> '',
			'class'			=> 'area_row',
			'content'		=> '[whychooseus icon="'.get_template_directory_uri().'/images/features-icon-1.png" title="Return Policy" description="Easy 30 Day Returns"][whychooseus icon="'.get_template_directory_uri().'/images/features-icon-2.png" title="100% Fresh" description="Fresh Grocery Delivered"][whychooseus icon="'.get_template_directory_uri().'/images/features-icon-3.png" title="24/7 Support" description="Concerns and Queries"][whychooseus icon="'.get_template_directory_uri().'/images/features-icon-4.png" title="Secured Payment" description="All Credit Card Accepted"]'
		),
	);

	$options = array();

	//Basic Settings
	$options[] = array(
		'name' => __('Basic Settings', 'groceem-pro'),
		'type' => 'heading');

	$options[] = array(
		'name' => __('Logo', 'groceem-pro'),
		'desc' => __('Upload your main logo here', 'groceem-pro'),
		'id' => 'logo',
		'class' => '',
		'std'	=> get_template_directory_uri().'/images/logo.png',
		//'std'	=> '',
		'type' => 'upload');
		
	$options[] = array(		
		'desc' => __('Change your custom logo height', 'groceem-pro'),
		'id' => 'logoheight',
		'std' => '26',
		'type' => 'text');
		
	$options[] = array(	
		'name' => __('Site title & Description', 'groceem-pro'),		
		'desc'	=> __('Check to show site title and description', 'groceem-pro'),
		'id'	=> 'hide_titledesc',
		'type'	=> 'checkbox',
		'std'	=> '');		
		
	$options[] = array(	
		'name' => __('Layout Option', 'groceem-pro'),		
		'desc'	=> __('Check To View Box Layout ', 'groceem-pro'),
		'id'	=> 'boxlayout',
		'type'	=> 'checkbox',
		'std'	=> '');
			
	$options[] = array(
		'name' => __('Sticky Header', 'groceem-pro'),
		'desc' => __('Check this to show sticky header on scroll', 'groceem-pro'),
		'id' => 'headstick',
		'std' => '',
		'type' => 'checkbox');		
			
	$options[] = array(
		'name' => __('Hide Animation', 'groceem-pro'),
		'desc' => __('Check this to hide animation on scroll', 'groceem-pro'),
		'id' => 'scrollanimation',
		'std' => '',
		'type' => 'checkbox');		

	$options[] = array(
		'name' => __('Custom CSS', 'groceem-pro'),
		'desc' => __('Some Custom Styling for your site. Place any css codes here instead of the style.css file.', 'groceem-pro'),
		'id' => 'style2',
		'std' => '',
		'type' => 'textarea');				

	 $options[] = array(
		'name' => __('Header Social Icons', 'groceem-pro'),
		'desc' => __('social icons for header', 'groceem-pro'),
		'id' => 'headersocialicon',
		'std' => '[social_area]
[social icon="fab fa-facebook-f" link="#"] 
[social icon="fab fa-twitter" link="#"] 
[social icon="fab fa-linkedin-in" link="#"] 
[social icon="fab fa-instagram" link="#"] 
[social icon="fab fa-youtube" link="#"]				
[/social_area]',
		'type' => 'textarea');		 
		
	$options[] = array(
		'desc' => __('Add Header Address', 'groceem-pro'),
		'id' => 'headeraddress',
		'std' => 'Melbourne - 2000, Str. Avenue, Australia',
		'type' => 'text');		

    $options[] = array(     
        'desc' => __('Check to hide header address and social links strip', 'groceem-pro'),
        'id' => 'headinfodatatop',
        'std' => '',
        'type' => 'checkbox');  

	$options[] = array(
		'name' => __('Header Contact Info', 'groceem-pro'),
		'desc' => __('Add Phone Number', 'groceem-pro'),
		'id' => 'headerphone',
		'std' => '123 456 7890',
		'type' => 'text');	
				
	$options[] = array(
		'desc' => __('Add Email Address', 'groceem-pro'),
		'id' => 'headeremail',
		'std' => 'contact@sitename.com',
		'type' => 'text');

	$options[] = array(
		'desc' => __('Add Email Address', 'groceem-pro'),
		'id' => 'openinghours',
		'std' => 'Open Hours: Mn – St 8:00 a.m. – 9:00 p.m.',
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Header Free Quote', 'groceem-pro'),
		'id' => 'headerrequestquote',
		'std' => '[button name="FREE QUOTE" link="#" target="_self"]',
		'type' => 'textarea');	
				
	$options[] = array(		
		'desc' => __('Check to hide header contact info strip', 'groceem-pro'),
		'id' => 'headinfodata',
		'std' => '',
		'type' => 'checkbox');	
        
    $options[] = array(
        'name' => __('Header Search', 'groceem-pro'),
        'desc' => __('Check to hide header search', 'groceem-pro'),
        'id' => 'headerseacrh',
        'std' => '',
        'type' => 'checkbox');  

        
    $options[] = array(
        'name' => __('Header Cart', 'groceem-pro'),
        'desc' => __('Check to hide header cart', 'groceem-pro'),
        'id' => 'headercart',
        'std' => '',
        'type' => 'checkbox');          	
 
	// font family start 		
	$options[] = array(
		'name' => __('Font Faces', 'groceem-pro'),
		'desc' => __('Select font for the body text', 'groceem-pro'),
		'id' => 'bodyfontface',
		'type' => 'select',
		'std' => 'Poppins',
		'options' => $font_types );
		
	$options[] = array(
		'desc' => __('Select font for the textual logo', 'groceem-pro'),
		'id' => 'logofontface',
		'type' => 'select',
		'std' => 'Poppins',
		'options' => $font_types );
		
	$options[] = array(
		'desc' => __('Select font for the navigation text', 'groceem-pro'),
		'id' => 'navfontface',
		'type' => 'select',
		'std' => 'Poppins',
		'options' => $font_types );
		
	$options[] = array(
		'desc' => __('Select font family for all heading tag.', 'groceem-pro'),
		'id' => 'headfontface',
		'type' => 'select',
		'std' => 'Poppins',
		'options' => $font_types );
		
	$options[] = array(
		'desc' => __('Select font for Section title', 'groceem-pro'),
		'id' => 'sectiontitlefontface',
		'type' => 'select',
		'std' => 'Poppins',
		'options' => $font_types );	
		
	$options[] = array(
		'desc' => __('Select font for Section subtitle', 'groceem-pro'),
		'id' => 'sectionsubtitlefontface',
		'type' => 'select',
		'std' => 'Poppins',
		'options' => $font_types );	
		
	$options[] = array(
		'desc' => __('Select font for footer title', 'groceem-pro'),
		'id' => 'footertitlefontface',
		'type' => 'select',
		'std' => 'Poppins',
		'options' => $font_types );	
	
	$options[] = array(
		'desc' => __('Select font for Slide title', 'groceem-pro'),
		'id' => 'slidetitlefontface',
		'type' => 'select',
		'std' => 'Poppins',
		'options' => $font_types );	
		
	$options[] = array(
		'desc' => __('Select font for Slide Description', 'groceem-pro'),
		'id' => 'slidedesfontface',
		'type' => 'select',
		'std' => 'Poppins',
		'options' => $font_types );	

		
	// font sizes start	
	$options[] = array(
		'name' => __('Font Sizes', 'groceem-pro'),
		'desc' => __('Select font size for body text', 'groceem-pro'),
		'id' => 'bodyfontsize',
		'type' => 'select',
		'std' => '16px',
		'options' => $font_sizes );
		
	$options[] = array(
		'desc' => __('Select font size for textual logo', 'groceem-pro'),
		'id' => 'logofontsize',
		'type' => 'select',
		'std' => '40px',
		'options' => $font_sizes );
		
	$options[] = array(
		'desc' => __('Select font size for navigation', 'groceem-pro'),
		'id' => 'navfontsize',
		'type' => 'select',
		'std' => '17px',
		'options' => $font_sizes );	
		
	$options[] = array(
		'desc' => __('Select font size for section sub title', 'groceem-pro'),
		'id' => 'secsubtitlesize',
		'type' => 'select',
		'std' => '21px',
		'options' => $font_sizes );	
		
	$options[] = array(
		'desc' => __('Select font size for section title', 'groceem-pro'),
		'id' => 'sectitlesize',
		'type' => 'select',
		'std' => '45px',
		'options' => $font_sizes );
		
	$options[] = array(
		'desc' => __('Select font size for footer title', 'groceem-pro'),
		'id' => 'ftfontsize',
		'type' => 'select',
		'std' => '20px',
		'options' => $font_sizes );	
		
	$options[] = array(
		'desc' => __('Select font size for sidebar widgets title', 'groceem-pro'),
		'id' => 'sidebarfontsize',
		'type' => 'select',
		'std' => '24px',
		'options' => $font_sizes );	

	$options[] = array(
		'desc' => __('Select h1 font size', 'groceem-pro'),
		'id' => 'h1fontsize',
		'std' => '30px',
		'type' => 'select',
		'options' => $font_sizes);

	$options[] = array(
		'desc' => __('Select h2 font size', 'groceem-pro'),
		'id' => 'h2fontsize',
		'std' => '30px',
		'type' => 'select',
		'options' => $font_sizes);

	$options[] = array(
		'desc' => __('Select h3 font size', 'groceem-pro'),
		'id' => 'h3fontsize',
		'std' => '25px',
		'type' => 'select',
		'options' => $font_sizes);

	$options[] = array(
		'desc' => __('Select h4 font size', 'groceem-pro'),
		'id' => 'h4fontsize',
		'std' => '20px',
		'type' => 'select',
		'options' => $font_sizes);

	$options[] = array(
		'desc' => __('Select h5 font size', 'groceem-pro'),
		'id' => 'h5fontsize',
		'std' => '19px',
		'type' => 'select',
		'options' => $font_sizes);

	$options[] = array(
		'desc' => __('Select h6 font size', 'groceem-pro'),
		'id' => 'h6fontsize',
		'std' => '17px',
		'type' => 'select',
		'options' => $font_sizes);


	// font colors start

	$options[] = array(
		'name' => __('Site Colors Scheme', 'groceem-pro'),
		'desc' => __('Change the color scheme of hole site', 'groceem-pro'),
		'id' => 'colorscheme',
		'std' => '#58a740',
		'type' => 'color');

	$options[] = array(
		'desc' => __('change hover/active color scheme for hole site', 'groceem-pro'),
		'id' => 'allsitehovercolor',
		'std' => '#ed9f1e',
		'type' => 'color');		

	$options[] = array(
		'desc' => __('change third color scheme for hole site', 'groceem-pro'),
		'id' => 'allsitethirdcolor',
		'std' => '#c0777c',
		'type' => 'color');		


/*		
	$options[] = array(		
		'desc' => __('Select background color opacity for special services', 'wedshot-pro'),
		'id' => 'servicesbgpacity',
		'std' => '0.8',
		'type' => 'select',
		'options'	=> array('1'=>1, '0.9'=>0.9,'0.8'=>0.8,'0.7'=>0.7,'0.6'=>0.6,'0.5'=>0.5,'0.4'=>0.4,'0.3'=>0.3,'0.2'=>0.2,));	
		*/
	$options[] = array(	
		'name' => __('Font Colors', 'groceem-pro'),	
		'desc' => __('Select font color for the body text', 'groceem-pro'),
		'id' => 'bodyfontcolor',
		'std' => '#494848',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font color for textual logo', 'groceem-pro'),
		'id' => 'logofontcolor',
		'std' => '#282828',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select font color for logo tagline', 'groceem-pro'),
		'id' => 'logotaglinecolor',
		'std' => '#232323',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select font color for header top phone and email', 'groceem-pro'),
		'id' => 'headertopfontcolor',
		'std' => '#ffffff',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font color for section title', 'groceem-pro'),
		'id' => 'sectitlecolor',
		'std' => '#232323',
		'type' => 'color');	
	
	$options[] = array(
		'desc' => __('Select font color for navigation', 'groceem-pro'),
		'id' => 'navfontcolor',
		'std' => '#232323',
		'type' => 'color');

/*	$options[] = array(
		'desc' => __('Select font hover submenu color for navigation', 'groceem-pro'),
		'id' => 'navactivefontcolor',
		'std' => '#eea702',
		'type' => 'color'); */
		
	$options[] = array(
		'desc' => __('Select font color for widget title', 'groceem-pro'),
		'id' => 'wdgttitleccolor',
		'std' => '#282828',
		'type' => 'color');

	$options[] = array(
		'desc' => __('Select font color for footer title', 'groceem-pro'),
		'id' => 'foottitlecolor',
		'std' => '#252525',
		'type' => 'color');	
				
	$options[] = array(
		'desc' => __('Select font color for footer', 'groceem-pro'),
		'id' => 'footdesccolor',
		'std' => '#161616',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font color for footer left text (copyright)', 'groceem-pro'),
		'id' => 'copycolor',
		'std' => '#343434',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select font color for footer right text (design by)', 'groceem-pro'),
		'id' => 'designcolor',
		'std' => '#343434',
		'type' => 'color');
    
    $options[] = array(
        'desc' => __('Select font color for footer copyright links', 'groceem-pro'),
        'id' => 'copylinkshover',
        'std' => '#343434',
        'type' => 'color'); 

	$options[] = array(
		'desc' => __('Select font hover color for links / anchor tags', 'groceem-pro'),
		'id' => 'linkhovercolor',
		'std' => '#272727',
		'type' => 'color');			
		
	$options[] = array(
		'desc' => __('Select font color for sidebar li a', 'groceem-pro'),
		'id' => 'sidebarfontcolor',
		'std' => '#78797c',
		'type' => 'color');	

	$options[] = array(
		'desc' => __('Select h1 font color', 'groceem-pro'),
		'id' => 'h1fontcolor',
		'std' => '#282828',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select h2 font color', 'groceem-pro'),
		'id' => 'h2fontcolor',
		'std' => '#282828',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select h3 font color', 'groceem-pro'),
		'id' => 'h3fontcolor',
		'std' => '#282828',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select h4 font color', 'groceem-pro'),
		'id' => 'h4fontcolor',
		'std' => '#282828',
		'type' => 'color');	

	$options[] = array(
		'desc' => __('Select h5 font color', 'groceem-pro'),
		'id' => 'h5fontcolor',
		'std' => '#282828',
		'type' => 'color');	

	$options[] = array(
		'desc' => __('Select h6 font color', 'groceem-pro'),
		'id' => 'h6fontcolor',
		'std' => '#282828',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font color for social icons color', 'groceem-pro'),
		'id' => 'socialcolor',
		'std' => '#ffffff',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font color for social icons hover color', 'groceem-pro'),
		'id' => 'socialcolorhover',
		'std' => '#ffffff',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font color for sidebar widget box', 'groceem-pro'),
		'id' => 'widgetboxfontcolor',
		'std' => '#6e6d6d',
		'type' => 'color');	
 
 	$options[] = array(
		'desc' => __('Select font color for toggle menu on responsive', 'groceem-pro'),
		'id' => 'togglemenucolor',
		'std' => '#ffffff',
		'type' => 'color');					
		
	// Background start	
	$options[] = array(
		'name' => __('Background Colors', 'groceem-pro'),	
		'desc' => __('Select background color for header', 'groceem-pro'),
		'id' => 'headerbgcolor',
		'std' => '#ffffff',
		'type' => 'color');	
		
	$options[] = array(		
		'desc' => __('Select background opacity color for header', 'groceem-pro'),
		'id' => 'headerbgpacity',
		'std' => '1',
		'type' => 'select',
		'options'	=> array('1'=>1, '0.9'=>0.9,'0.8'=>0.8,'0.7'=>0.7,'0.6'=>0.6,'0.5'=>0.5,'0.4'=>0.4,'0.3'=>0.3,'0.2'=>0.2,'0.1'=>0.1, '0.0'=>0.0));			

	$options[] = array(		
		'desc' => __('Select background opacity color for search PopUp', 'groceem-pro'),
		'id' => 'headersearbgpacity',
		'std' => '0.9',
		'type' => 'select',
		'options'	=> array('1'=>1, '0.9'=>0.9,'0.8'=>0.8,'0.7'=>0.7,'0.6'=>0.6,'0.5'=>0.5,'0.4'=>0.4,'0.3'=>0.3,'0.2'=>0.2,'0.1'=>0.1, '0.0'=>0.0));
		
	$options[] = array(		
		'desc' => __('Select background opacity color for video play button', 'groceem-pro'),
		'id' => 'palybtnopacity',
		'std' => '0.8',
		'type' => 'select',
		'options'	=> array('1'=>1, '0.9'=>0.9,'0.8'=>0.8,'0.7'=>0.7,'0.6'=>0.6,'0.5'=>0.5,'0.4'=>0.4,'0.3'=>0.3,'0.2'=>0.2,'0.1'=>0.1, '0.0'=>0.0,));				

  
    $options[] = array(     
        'desc' => __('Select background color for footer', 'groceem-pro'),
        'id' => 'footerbgcolor',
        'std' => '#f6f3ee',
        'type' => 'color');     

    $options[] = array(     
        'desc' => __('Select background color for services', 'groceem-pro'),
        'id' => 'servicesbgcolor',
        'std' => '#87b900',
        'type' => 'color');     

	$options[] = array(
		'desc' => __('Select background color for Footer Copyright', 'groceem-pro'),
		'id' => 'copybgcolor',
		'std' => '#ebebeb',
		'type' => 'color');		

	$options[] = array(
		'desc' => __('Select background color for client testimonials pager dots', 'groceem-pro'),
		'id' => 'testidotsbgcolor',
		'std' => '#ffffff',
		'type' => 'color');	

	$options[] = array(
		'desc' => __('Select background color for client testimonials pager dots active', 'groceem-pro'),
		'id' => 'testidotsactivebgcolor',
		'std' => '#000000',
		'type' => 'color');	
			
	$options[] = array(
		'desc' => __('Select background color for sidebar widget search box', 'groceem-pro'),
		'id' => 'widgetboxbgcolor',
		'std' => '#F0EFEF',
		'type' => 'color');	
		
 	$options[] = array(
		'desc' => __('Select background color for Social Icons', 'groceem-pro'),
		'id' => 'socialcolorbg',
		'std' => '#1b1b1b',
		'type' => 'color');			
 	
	// Border colors			
	$options[] = array(	
		'name' => __('Border Colors', 'groceem-pro'),		
		'desc' => __('Select border color for sidebar li a', 'groceem-pro'),
		'id' => 'sidebarliaborder',
		'std' => '#eeeeee',
		'type' => 'color');	
		
	$options[] = array(			
		'desc' => __('Select border color for gallery filter', 'groceem-pro'),
		'id' => 'galleryfilterbdr',
		'std' => '#494949',
		'type' => 'color');	

	// Default Buttons		
	$options[] = array(
		'name' => __('Button Colors', 'groceem-pro'),
		'desc' => __('Select background hover color for default button', 'groceem-pro'),
		'id' => 'btnbghvcolor',
		'std' => '#202020',
		'type' => 'color');		

	$options[] = array(
		'desc' => __('Select font color default button', 'groceem-pro'),
		'id' => 'btntxtcolor',
		'std' => '#ffffff',
		'type' => 'color');

	$options[] = array(
		'desc' => __('Select font hover color for default button', 'groceem-pro'),
		'id' => 'btntxthvcolor',
		'std' => '#ffffff',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select background color for shop now button on slider', 'groceem-pro'),
		'id' => 'shopbtnbgcolor',
		'std' => '#202020',
		'type' => 'color');	
													

	// Slider Caption colors
	$options[] = array(	
		'name' => __('Slider Caption Colors', 'groceem-pro'),				
		'desc' => __('Select font color for slider title', 'groceem-pro'),
		'id' => 'slidetitlecolor',
		'std' => '#252525',
		'type' => 'color');			
		
	$options[] = array(		
		'desc' => __('Select font color for slider description', 'groceem-pro'),
		'id' => 'slidedesccolor',
		'std' => '#161616',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font size for slider title', 'groceem-pro'),
		'id' => 'slidetitlefontsize',
		'type' => 'select',
		'std' => '46px',
		'options' => $font_sizes );
		
	$options[] = array(
		'desc' => __('Select font size for slider description', 'groceem-pro'),
		'id' => 'slidedescfontsize',
		'type' => 'select',
		'std' => '16px',
		'options' => $font_sizes );
		
	// Slider controls colors		
	/*$options[] = array(
		'name' => __('Slider Colors Options', 'groceem-pro'),
		'desc' => __('Select background color for slider caption', 'groceem-pro'),
		'id' => 'sldcaptionbg',
		'std' => '#2d2927',
		'type' => 'color');
		
 	$options[] = array(		
		'desc' => __('Select background color opacity for slider caption', 'groceem-pro'),
		'id' => 'sldcaptionbgpacity',
		'std' => '0.5',
		'type' => 'select',
		'options'	=> array('1'=>1, '0.9'=>0.9,'0.8'=>0.8,'0.7'=>0.7,'0.6'=>0.6,'0.5'=>0.5,'0.4'=>0.4,'0.3'=>0.3,'0.2'=>0.2,));	*/
		
	$options[] = array(
		'name' => __('Slider controls Colors', 'groceem-pro'),
		'desc' => __('Select background color for slider pager', 'groceem-pro'),
		'id' => 'sldpagebg',
		'std' => '#555555',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select background color for slider navigation arrows', 'groceem-pro'),
		'id' => 'sldarrowbg',
		'std' => '#ffffff',
		'type' => 'color');	
		
	$options[] = array(		
		'desc' => __('Select background opacity color for slider navigation arrows', 'groceem-pro'),
		'id' => 'sldarrowopacity',
		'std' => '1',
		'type' => 'select',
		'options'	=> array('1'=>1, '0.9'=>0.9,'0.8'=>0.8,'0.7'=>0.7,'0.6'=>0.6,'0.5'=>0.5,'0.4'=>0.4,'0.3'=>0.3,'0.2'=>0.2,));			

	$options[] = array(	
		'name' => __('Excerpt Lenth', 'groceem-pro'),		
		'desc' => __('Select excerpt length for latest news boxes section', 'groceem-pro'),
		'id' => 'latestnewslength',
		'std' => '15',
		'type' => 'text');	
		
	$options[] = array(		
		'desc' => __('Select excerpt length for testimonials section', 'groceem-pro'),
		'id' => 'testimonialsexcerptlength',
		'std' => '25',
		'type' => 'text');
		
	$options[] = array(		
		'desc' => __('Select excerpt length for blog post', 'groceem-pro'),
		'id' => 'blogpostexcerptlength',
		'std' => '45',
		'type' => 'text');
		
	$options[] = array(	
		'name' => __('Read More Custom Text', 'groceem-pro'),		
		'desc' => __('Change read more button text for blog posts section ', 'groceem-pro'),
		'id' => 'blogpostreadmoretext',
		'std' => 'Read More &rarr;',
		'type' => 'text');	
		
	$options[] = array(		
		'desc' => __('Change read more button text for latest blog post template', 'groceem-pro'),
		'id' => 'readmoretext_blogtemplates',
		'std' => 'Read more &rarr;',
		'type' => 'text');	
		
	$options[] = array(		
		'desc' => __('Change Show All Button text for photo gallery section', 'groceem-pro'),
		'id' => 'galleryshowallbtn',
		'std' => 'Show All',
		'type' => 'text');	
		
	$options[] = array(		
		'desc' => __('Change menu word on responsive view', 'groceem-pro'),
		'id' => 'menuwordchange',
		'std' => 'Menu',
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Blog Single Layout', 'groceem-pro'),
		'desc' => __('Select layout. eg:Boxed, Wide', 'groceem-pro'),
		'id' => 'singlelayout',
		'type' => 'select',
		'std' => 'singleright',
		'options' => array('singleright'=>'Blog Single Right Sidebar', 'singleleft'=>'Blog Single Left Sidebar', 'sitefull'=>'Blog Single Full Width', 'nosidebar'=>'Blog Single No Sidebar') );	
		
	$options[] = array(
		'name' => __('Team Single Layout', 'groceem-pro'),
		'desc' => __('Select layout. eg:left,right,full', 'groceem-pro'),
		'id' => 'teamsinglelayout',
		'type' => 'select',
		'std' => 'sitefull',
		'options' => array('singleright'=>'Team Single Right Sidebar', 'singleleft'=>'Team Single Left Sidebar', 'sitefull'=>'Team Single Full Width', 'nosidebar'=>'Team Single No Sidebar') );	
		
		
	$options[] = array(
		'name' => __('Woocommerce Page Layout', 'groceem-pro'),
		'desc' => __('Select layout. eg:right-sidebar, left-sidebar, full-width', 'groceem-pro'),
		'id' => 'woocommercelayout',
		'type' => 'select',
		'std' => 'woocommercesitefull',
		'options' => array('woocommerceright'=>'Woocommerce Right Sidebar', 'woocommerceleft'=>'Woocommerce Left Sidebar', 'woocommercesitefull'=>'Woocommerce Full Width') );	
		
	$options[] = array(
		'name' => __('Testimonials Single Layout', 'groceem-pro'),
		'desc' => __('Select layout. eg:left,right,full', 'groceem-pro'),
		'id' => 'testimonialsinglelayout',
		'type' => 'select',
		'std' => 'sitefull',
		'options' => array('singleright'=>'Testimonials Single Right Sidebar', 'singleleft'=>'Testimonials Single Left Sidebar', 'sitefull'=>'Testimonials Single Full Width', 'nosidebar'=>'Testimonials Single No Sidebar') );	
	
	
	$options[] = array(	
		'name' => __('Testimonials Rotating Speed', 'groceem-pro'),	
		'desc' => __('manage testimonials rotating speed.', 'groceem-pro'),
		'id' => 'testimonialsrotatingspeed',
		'std' => '8000',
		'type' => 'text');	
		
	$options[] = array(		
		'desc' => __('True/False Auto play Testimonials.','groceem-pro'),
		'id' => 'testimonialsautoplay',
		'std' => 'true',
		'type' => 'select',
		'options' => array('true'=>'True', 'false'=>'False'));			
		
	//Layout Settings
	$options[] = array(
		'name' => __('Sections', 'groceem-pro'),
		'type' => 'heading');
				

// Welcome Section

/*$options[] = array(	
		'name' => __('Top Services Section Title', 'groceem-pro'),
		'id' => 'topboxtitle',
		'std' => 'BEST SERVICE IN YOUR CITY',
		'type' => 'text');	 
*/

	$options[] = array(	
		'name' => __('Top Three Box Section', 'groceem-pro'),
		'desc'	=> __('First box for services section','groceem-pro'),
		'id' 	=> 'box1',
		'type'	=> 'select',
		'options' => $options_pages,
	);
	
	$options[] = array(		
		'desc' => __('upload image for first box.', 'groceem-pro'),
		'id' => 'boximg1',
		'class' => '',
		'std'	=> '',
		'type' => 'upload');
	
	$options[] = array(	
		'desc'	=> __('Second box for services section','groceem-pro'),
		'id' 	=> 'box2',
		'type'	=> 'select',
		'options' => $options_pages,
	);
	
	$options[] = array(		
		'desc' => __('upload image for second box.', 'groceem-pro'),
		'id' => 'boximg2',
		'class' => '',
		'std'	=> '',
		'type' => 'upload');
	
	$options[] = array(	
		'desc'	=> __('Third box for services section','groceem-pro'),
		'id' 	=> 'box3',
		'type'	=> 'select',
		'options' => $options_pages,
	);
	
	$options[] = array(		
		'desc' => __('upload image for third box.', 'groceem-pro'),
		'id' => 'boximg3',
		'class' => '',
		'std'	=> '',
		'type' => 'upload');
	
	$options[] = array(	
		'desc'	=> __('Fourth box for services section','groceem-pro'),
		'id' 	=> 'box4',
		'type'	=> 'select',
		'options' => $options_pages,
	);
	
	$options[] = array(		
		'desc' => __('upload image for fourth box.', 'groceem-pro'),
		'id' => 'boximg4',
		'class' => '',
		'std'	=> '',
		'type' => 'upload');
		
	$options[] = array(	
		'desc'	=> __('Fifth box for services section','groceem-pro'),
		'id' 	=> 'box5',
		'type'	=> 'select',
		'options' => $options_pages,
	);
	
	$options[] = array(		
		'desc' => __('upload image for fifth box.', 'groceem-pro'),
		'id' => 'boximg5',
		'class' => '',
		'std'	=> '',
		'type' => 'upload');
		
	$options[] = array(	
		'desc'	=> __('Sixth box for services section','groceem-pro'),
		'id' 	=> 'box6',
		'type'	=> 'select',
		'options' => $options_pages,
	);
	
	$options[] = array(		
		'desc' => __('upload image for sixth box.', 'groceem-pro'),
		'id' => 'boximg6',
		'class' => '',
		'std'	=> '',
		'type' => 'upload');
		
	$options[] = array(	
		'desc' => __('Change read more button text for three boxes section', 'groceem-pro'),
		'id' => 'readmorebutton',
		'std' => 'View Details',
		'type' => 'text');
		
	$options[] = array(		
		'desc' => __('Select excerpt length for three boxes section', 'groceem-pro'),
		'id' => 'pageboxlength',
		'std' => '15',
		'type' => 'text');			

	$options[] = array(
		'desc' => __('Select background color for three boxes section', 'groceem-pro'),
		'id' => 'servicessection',
		'std' => '#f9f9f9',
		'type' => 'color');		

	$options[] = array(			
			'desc'	=> __('Check to hide three column section', 'groceem-pro'),
			'id'	=> 'hidefourbxsec',
			'type'	=> 'checkbox',
			'std'	=> '');
			
			
// Welcome Section
 $options[] = array(	
		'name' => __('Six Boxes Section', 'groceem-pro'),
		'desc'	=> __('Enter Section Title','groceem-pro'),
		'id' => 'topboxtitle',
		'std' => 'From our family farm to your Home',
		'type' => 'text');	 
 
	$options[] = array(	
		'desc'	=> __('Select page for first box','groceem-pro'),
		'id' 	=> 'sec2box1',
		'type'	=> 'select',
		'options' => $options_pages,
	);
	
	$options[] = array(		
		'desc' => __('upload image for first box.', 'groceem-pro'),
		'id' => 'sec2boximg1',
		'std'	=> '',
		'type' => 'upload');
	
	$options[] = array(	
		'desc'	=> __('Select page for second box','groceem-pro'),
		'id' 	=> 'sec2box2',
		'type'	=> 'select',
		'options' => $options_pages,
	);
	
	$options[] = array(		
		'desc' => __('upload image for second box.', 'groceem-pro'),
		'id' => 'sec2boximg2',
		'std'	=> '',
		'type' => 'upload');
	
	$options[] = array(	
		'desc'	=> __('Select page for third box','groceem-pro'),
		'id' 	=> 'sec2box3',
		'type'	=> 'select',
		'options' => $options_pages,
	);
	
	$options[] = array(		
		'desc' => __('upload image for third box.', 'groceem-pro'),
		'id' => 'sec2boximg3',
		'std'	=> '',
		'type' => 'upload');
	
	$options[] = array(	
		'desc'	=> __('Select page for fourth box','groceem-pro'),
		'id' 	=> 'sec2box4',
		'type'	=> 'select',
		'options' => $options_pages,
	);
	
	$options[] = array(		
		'desc' => __('upload image for fourth box.', 'groceem-pro'),
		'id' => 'sec2boximg4',
		'std'	=> '',
		'type' => 'upload');
		
	$options[] = array(	
		'desc'	=> __('Select page for fifth box','groceem-pro'),
		'id' 	=> 'sec2box5',
		'type'	=> 'select',
		'options' => $options_pages,
	);
	
	$options[] = array(		
		'desc' => __('upload image for fifth box.', 'groceem-pro'),
		'id' => 'sec2boximg5',
		'std'	=> '',
		'type' => 'upload');
		
	$options[] = array(	
		'desc'	=> __('Select page for sixth box','groceem-pro'),
		'id' 	=> 'sec2box6',
		'type'	=> 'select',
		'options' => $options_pages,
	);
	
	$options[] = array(		
		'desc' => __('upload image for sixth box.', 'groceem-pro'),
		'id' => 'sec2boximg6',
		'std'	=> '',
		'type' => 'upload');	

	$options[] = array(
		'desc' => __('Select background color for Sixth boxes section', 'groceem-pro'),
		'id' => 'servicessectiontwo',
		'std' => '#ffffff',
		'type' => 'color');		

	$options[] = array(			
			'desc'	=> __('Check to hide above Sixth boxes section', 'groceem-pro'),
			'id'	=> 'hidesixbxsec',
			'type'	=> 'checkbox',
			'std'	=> '');			
	
			
	//Section tab
	$options[] = array(
		'name' => __('Number of Sections', 'groceem-pro'),
		'desc' => __('Select number of sections', 'groceem-pro'),
		'id' => 'numsection',
		'type' => 'select',
		'std' => '10',
		'options' => array_combine(range(1,30), range(1,30)) );

	$numsecs = of_get_option( 'numsection', 10 );

	for( $n=1; $n<=$numsecs; $n++){
		$options[] = array(
			'desc' => __("<h3>Section ".$n."</h3>", 'groceem-pro'),
			'class' => 'toggle_title',
			'type' => 'info');
	
		$options[] = array(
			'name' => __('Section Main Title', 'groceem-pro'),
			'id' => 'sectiontitle'.$n,
			'std' => ( ( isset($section_text[$n]['section_title']) ) ? $section_text[$n]['section_title'] : '' ),
			'type' => 'text');
		
		$options[] = array(
			'name' => __('Section Sub Title', 'groceem-pro'),
			'id' => 'sectionsubtitle'.$n,
			'std' => ( ( isset($section_text[$n]['section_sub_title']) ) ? $section_text[$n]['section_sub_title'] : '' ),
			'type' => 'text');	
			
		$options[] = array(
			'name' => __('Section ID', 'groceem-pro'),
			'desc'	=> __('Enter your section ID here. SECTION ID MUST BE IN SMALL LETTERS ONLY AND DO NOT ADD SPACE OR SYMBOL.', 'groceem-pro'),
			'id' => 'menutitle'.$n,
			'std' => ( ( isset($section_text[$n]['menutitle']) ) ? $section_text[$n]['menutitle'] : '' ),
			'type' => 'text');
	$options[] = array(
			'name' => __('Section Title Color', 'groceem-pro'),
			'desc' => __('Select title color for section', 'groceem-pro'),
			'id' => 'titlecolor'.$n,
			'std' => ( ( isset($section_text[$n]['titlecolor']) ) ? $section_text[$n]['titlecolor'] : '' ),
			'type' => 'color');
		$options[] = array(
			'name' => __('Section Background Color', 'groceem-pro'),
			'desc' => __('Select background color for section', 'groceem-pro'),
			'id' => 'sectionbgcolor'.$n,
			'std' => ( ( isset($section_text[$n]['bgcolor']) ) ? $section_text[$n]['bgcolor'] : '' ),
			'type' => 'color');
			
		$options[] = array(
			'name' => __('Background Image', 'groceem-pro'),
			'id' => 'sectionbgimage'.$n,
			'class' => '',
			'std' => ( ( isset($section_text[$n]['bgimage']) ) ? $section_text[$n]['bgimage'] : '' ),
			'type' => 'upload');

		$options[] = array(
			'name' => __('Section CSS Class', 'groceem-pro'),
			'desc' => __('Set class for this section.', 'groceem-pro'),
			'id' => 'sectionclass'.$n,
			'std' => ( ( isset($section_text[$n]['class']) ) ? $section_text[$n]['class'] : '' ),
			'type' => 'text');
			
		$options[] = array(
			'name'	=> __('Hide Section', 'groceem-pro'),
			'desc'	=> __('Check to hide this section', 'groceem-pro'),
			'id'	=> 'hidesec'.$n,
			'type'	=> 'checkbox',
			'std'	=> '');

		$options[] = array(
			'name' => __('Section Content', 'groceem-pro'),
			'id' => 'sectioncontent'.$n,
			'std' => ( ( isset($section_text[$n]['content']) ) ? $section_text[$n]['content'] : '' ),
			'type' => 'editor');
	}


	//SLIDER SETTINGS
	$options[] = array(
		'name' => __('Homepage Slider', 'groceem-pro'),
		'type' => 'heading');
		
	$options[] = array(
		'name' => __('Inner Page Banner', 'groceem-pro'),
		'desc' => __('Upload inner page banner for site', 'groceem-pro'),
		'id' => 'innerpagebanner',
		'class' => '',
		'std'	=> get_template_directory_uri()."/images/inner-banner.jpg",
		'type' => 'upload');
		
		
	$options[] = array(
		'name' => __('Custom Slider Shortcode Area For Home Page', 'groceem-pro'),
		'desc' => __('Enter here your slider shortcode without php tag', 'groceem-pro'),
		'id' => 'customslider',
		'std' => '',
		'type' => 'textarea');		
		
	$options[] = array(
		'name' => __('Slider Effects and Timing', 'groceem-pro'),
		'desc' => __('Select slider effect.','groceem-pro'),
		'id' => 'slideefect',
		'std' => 'random',
		'type' => 'select',
		'options' => array('random'=>'Random', 'fade'=>'Fade', 'fold'=>'Fold', 'sliceDown'=>'Slide Down', 'sliceDownLeft'=>'Slide Down Left', 'sliceUp'=>'Slice Up', 'sliceUpLeft'=>'Slice Up Left', 'sliceUpDown'=>'Slice Up Down', 'sliceUpDownLeft'=>'Slice Up Down Left', 'slideInRight'=>'SlideIn Right', 'slideInLeft'=>'SlideIn Left', 'boxRandom'=>'Box Random', 'boxRain'=>'Box Rain', 'boxRainReverse'=>'Box Rain Reverse', 'boxRainGrow'=>'Box Rain Grow', 'boxRainGrowReverse'=>'Box Rain Grow Reverse' ));
		
	$options[] = array(
		'desc' => __('Animation speed should be multiple of 100.', 'groceem-pro'),
		'id' => 'slideanim',
		'std' => 500,
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Add slide pause time.', 'groceem-pro'),
		'id' => 'slidepause',
		'std' => 4000,
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Slide Controllers', 'groceem-pro'),
		'desc' => __('Hide/Show Direction Naviagtion of slider.','groceem-pro'),
		'id' => 'slidenav',
		'std' => 'false',
		'type' => 'select',
		'options' => array('true'=>'Show', 'false'=>'Hide'));
		
	$options[] = array(
		'desc' => __('Hide/Show pager of slider.','groceem-pro'),
		'id' => 'slidepage',
		'std' => 'true',
		'type' => 'select',
		'options' => array('true'=>'Show', 'false'=>'Hide'));
		
	$options[] = array(
		'desc' => __('Pause Slide on Hover.','groceem-pro'),
		'id' => 'slidepausehover',
		'std' => 'false',
		'type' => 'select',
		'options' => array('true'=>'Yes', 'false'=>'No'));	
		
	$options[] = array(
		'name' => __('Slider Image 1', 'groceem-pro'),
		'desc' => __('First Slide', 'groceem-pro'),
		'id' => 'slide1',
		'class' => '',
		'std' => get_template_directory_uri()."/images/slides/slider1.jpg",
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 1', 'groceem-pro'),
		'id' => 'slidetitle1',
		'std' => 'Check out our best Weekly price',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'groceem-pro'),
		'id' => 'slidedesc1',
		'std' => 'Curabitur ligula enim, pellen sitam etullamcorp molesti viverra nonelit.',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'groceem-pro'),
		'id' => 'slidebutton1',
		'std' => 'VIEW MORE',
		'type' => 'text');	

	$options[] = array(
		'desc' => __('Slide Url for Read More Button', 'groceem-pro'),
		'id' => 'slideurl1',
		'std' => '#',
		'type' => 'text');		

	$options[] = array(
		'desc' => __('Shop Now Text', 'groceem-pro'),
		'id' => 'shopnow1',
		'std' => 'SHOP NOW',
		'type' => 'text');			
		
	$options[] = array(
		'desc' => __('Slide Url for Shop Now Button', 'groceem-pro'),
		'id' => 'shopnowurl1',
		'std' => '#',
		'type' => 'text');			
	
	$options[] = array(
		'name' => __('Slider Image 2', 'groceem-pro'),
		'desc' => __('Second Slide', 'groceem-pro'),
		'class' => '',
		'id' => 'slide2',
		'std' => get_template_directory_uri()."/images/slides/slider2.jpg",
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 2', 'groceem-pro'),
		'id' => 'slidetitle2',
		'std' => 'We are the Best service provider',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'groceem-pro'),
		'id' => 'slidedesc2',
		'std' => 'Morbi ac justo rutrum, euismod diam ut, accumsan lorem. Vestibulum sit amet dolor sem.',
		'type' => 'textarea');	
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'groceem-pro'),
		'id' => 'slidebutton2',
		'std' => 'READ MORE',
		'type' => 'text');			
		
	$options[] = array(
		'desc' => __('Slide Url for Read More Button', 'groceem-pro'),
		'id' => 'slideurl2',
		'std' => '#',
		'type' => 'text');	


	$options[] = array(
		'desc' => __('Shop Now Text', 'groceem-pro'),
		'id' => 'shopnow2',
		'std' => 'SHOP NOW',
		'type' => 'text');			
		
	$options[] = array(
		'desc' => __('Slide Url for Shop Now Button', 'groceem-pro'),
		'id' => 'shopnowurl2',
		'std' => '#',
		'type' => 'text');	
			
	$options[] = array(
		'name' => __('Slider Image 3', 'groceem-pro'),
		'desc' => __('Third Slide', 'groceem-pro'),
		'id' => 'slide3',
		'class' => '',
		'std' => get_template_directory_uri()."/images/slides/slider3.jpg",
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 3', 'groceem-pro'),
		'id' => 'slidetitle3',
		'std' => 'Choose the Best healthier way of life',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'groceem-pro'),
		'id' => 'slidedesc3',
		'std' => 'Integer consectetur felis at metus finibus, ac viverra sapien gravida',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'groceem-pro'),
		'id' => 'slidebutton3',
		'std' => 'DISCOVER',
		'type' => 'text');			
		
	$options[] = array(
		'desc' => __('Slide Url for Read More Button', 'groceem-pro'),
		'id' => 'slideurl3',
		'std' => '#',
		'type' => 'text');

	$options[] = array(
		'desc' => __('Shop Now Text', 'groceem-pro'),
		'id' => 'shopnow3',
		'std' => 'SHOP NOW',
		'type' => 'text');			
		
	$options[] = array(
		'desc' => __('Slide Url for Shop Now Button', 'groceem-pro'),
		'id' => 'shopnowurl3',
		'std' => '#',
		'type' => 'text');			
	
	$options[] = array(
		'name' => __('Slider Image 4', 'groceem-pro'),
		'desc' => __('Third Slide', 'groceem-pro'),
		'id' => 'slide4',
		'class' => '',
		'std' => '',
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 4', 'groceem-pro'),
		'id' => 'slidetitle4',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'groceem-pro'),
		'id' => 'slidedesc4',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'groceem-pro'),
		'id' => 'slidebutton4',
		'std' => '',
		'type' => 'text');			
		
	$options[] = array(
		'desc' => __('Slide Url for Read More Button', 'groceem-pro'),
		'id' => 'slideurl4',
		'std' => '',
		'type' => 'text');

	$options[] = array(
		'desc' => __('Shop Now Text', 'groceem-pro'),
		'id' => 'shopnow4',
		'std' => '',
		'type' => 'text');			
		
	$options[] = array(
		'desc' => __('Slide Url for Shop Now Button', 'groceem-pro'),
		'id' => 'shopnowurl4',
		'std' => '',
		'type' => 'text');							
	
	$options[] = array(
		'name' => __('Slider Image 5', 'groceem-pro'),
		'desc' => __('Fifth Slide', 'groceem-pro'),
		'id' => 'slide5',
		'class' => '',
		'std' => '',
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 5', 'groceem-pro'),
		'id' => 'slidetitle5',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'groceem-pro'),
		'id' => 'slidedesc5',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'groceem-pro'),
		'id' => 'slidebutton5',
		'std' => '',
		'type' => 'text');			
		
	$options[] = array(
		'desc' => __('Slide Url for Read More Button', 'groceem-pro'),
		'id' => 'slideurl5',
		'std' => '',
		'type' => 'text');

	$options[] = array(
		'desc' => __('Shop Now Text', 'groceem-pro'),
		'id' => 'shopnow5',
		'std' => '',
		'type' => 'text');			
		
	$options[] = array(
		'desc' => __('Slide Url for Shop Now Button', 'groceem-pro'),
		'id' => 'shopnowurl5',
		'std' => '',
		'type' => 'text');	
				
	$options[] = array(
		'name' => __('Slider Image 6', 'groceem-pro'),
		'desc' => __('Sixth Slide', 'groceem-pro'),
		'id' => 'slide6',
		'class' => '',
		'std' => '',
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 6', 'groceem-pro'),
		'id' => 'slidetitle6',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'groceem-pro'),
		'id' => 'slidedesc6',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'groceem-pro'),
		'id' => 'slidebutton6',
		'std' => '',
		'type' => 'text');		
		
	$options[] = array(
		'desc' => __('Slide Url for Read More Button', 'groceem-pro'),
		'id' => 'slideurl6',
		'std' => '',
		'type' => 'text');

	$options[] = array(
		'desc' => __('Shop Now Text', 'groceem-pro'),
		'id' => 'shopnow6',
		'std' => '',
		'type' => 'text');			
		
	$options[] = array(
		'desc' => __('Slide Url for Shop Now Button', 'groceem-pro'),
		'id' => 'shopnowurl6',
		'std' => '',
		'type' => 'text');	
				
	$options[] = array(
		'name' => __('Slider Image 7', 'groceem-pro'),
		'desc' => __('Seventh Slide', 'groceem-pro'),
		'id' => 'slide7',
		'class' => '',
		'std' => '',
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 7', 'groceem-pro'),
		'id' => 'slidetitle7',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'groceem-pro'),
		'id' => 'slidedesc7',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'groceem-pro'),
		'id' => 'slidebutton7',
		'std' => '',
		'type' => 'text');			
		
	$options[] = array(
		'desc' => __('Slide Url for Read More Button', 'groceem-pro'),
		'id' => 'slideurl7',
		'std' => '',
		'type' => 'text');

	$options[] = array(
		'desc' => __('Shop Now Text', 'groceem-pro'),
		'id' => 'shopnow7',
		'std' => '',
		'type' => 'text');			
		
	$options[] = array(
		'desc' => __('Slide Url for Shop Now Button', 'groceem-pro'),
		'id' => 'shopnowurl7',
		'std' => '',
		'type' => 'text');	
				
	$options[] = array(
		'name' => __('Slider Image 8', 'groceem-pro'),
		'desc' => __('Eighth Slide', 'groceem-pro'),
		'id' => 'slide8',
		'class' => '',
		'std' => '',
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 8', 'groceem-pro'),
		'id' => 'slidetitle8',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'groceem-pro'),
		'id' => 'slidedesc8',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'groceem-pro'),
		'id' => 'slidebutton8',
		'std' => '',
		'type' => 'text');		
		
	$options[] = array(
		'desc' => __('Slide Url for Read More Button', 'groceem-pro'),
		'id' => 'slideurl8',
		'std' => '',
		'type' => 'text');

	$options[] = array(
		'desc' => __('Shop Now Text', 'groceem-pro'),
		'id' => 'shopnow8',
		'std' => '',
		'type' => 'text');			
		
	$options[] = array(
		'desc' => __('Slide Url for Shop Now Button', 'groceem-pro'),
		'id' => 'shopnowurl8',
		'std' => '',
		'type' => 'text');	
				
	$options[] = array(
		'name' => __('Slider Image 9', 'groceem-pro'),
		'desc' => __('Ninth Slide', 'groceem-pro'),
		'id' => 'slide9',
		'class' => '',
		'std' => '',
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 9', 'groceem-pro'),
		'id' => 'slidetitle9',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'groceem-pro'),
		'id' => 'slidedesc9',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'groceem-pro'),
		'id' => 'slidebutton9',
		'std' => '',
		'type' => 'text');			
		
	$options[] = array(
		'desc' => __('Slide Url for Read More Button', 'groceem-pro'),
		'id' => 'slideurl9',
		'std' => '',
		'type' => 'text');

	$options[] = array(
		'desc' => __('Shop Now Text', 'groceem-pro'),
		'id' => 'shopnow9',
		'std' => '',
		'type' => 'text');			
		
	$options[] = array(
		'desc' => __('Slide Url for Shop Now Button', 'groceem-pro'),
		'id' => 'shopnowurl9',
		'std' => '',
		'type' => 'text');	
				
	$options[] = array(
		'name' => __('Slider Image 10', 'groceem-pro'),
		'desc' => __('Tenth Slide', 'groceem-pro'),
		'id' => 'slide10',
		'class' => '',
		'std' => '',
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 10', 'groceem-pro'),
		'id' => 'slidetitle10',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'groceem-pro'),
		'id' => 'slidedesc10',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'groceem-pro'),
		'id' => 'slidebutton10',
		'std' => '',
		'type' => 'text');			
	
	$options[] = array(
		'desc' => __('Slide Url for Read More Button', 'groceem-pro'),
		'id' => 'slideurl10',
		'std' => '',
		'type' => 'text');

	$options[] = array(
		'desc' => __('Shop Now Text', 'groceem-pro'),
		'id' => 'shopnow10',
		'std' => '',
		'type' => 'text');			
		
	$options[] = array(
		'desc' => __('Slide Url for Shop Now Button', 'groceem-pro'),
		'id' => 'shopnowurl10',
		'std' => '',
		'type' => 'text');		

	//Footer SETTINGS
    $options[] = array(
        'name' => __('Footer', 'groceem-pro'),
        'type' => 'heading');
        
    $options[] = array(
        'name' => __('Footer Layout', 'groceem-pro'),
        'desc' => __('footer Select layout. eg:Column, 1, 2, 3 and 4', 'groceem-pro'),
        'id' => 'footerlayout',
        'type' => 'select',
        'std' => 'fourcolumn',
        'options' => array('onecolumnnone'=>'Footer Hide', 'onecolumn'=>'Footer 1 column', 'twocolumn'=>'Footer 2 column', 'threecolumn'=>'Footer 3 column', 'fourcolumn'=>'Footer 4 column', ) );          

    // $options[] = array(
    //     'name' => __('Footer About Logo', 'groceem-pro'),
    //     'desc' => __('Logo for footer', 'groceem-pro'),
    //     'id' => 'abouttitlelogo',
    //     'std' => get_template_directory_uri().'/images/footer-logo.png',
    //     'type' => 'upload');
                    
    $options[] = array(
        'name' => __('Footer About Title', 'groceem-pro'),
        'desc' => __('About Insurer title for footer', 'groceem-pro'),
        'id' => 'abouttitle',
        'std' => 'GROCEEM',
        'type' => 'text');
 
    $options[] = array(
        'name' => __('About Description', 'groceem-pro'),
        'desc' => __('about description for footer', 'groceem-pro'),
        'id' => 'aboutusdescription',
        'std' => 'Morbi ac justo rutrum, euismod diam ut, accums Vestibulum sit amet dolor sem. Aliquam erat vus risus ex, volutpat sit amet ultricies.',
        'type' => 'textarea');
        
  $options[] = array(
        'name' => __('Client Logos', 'groceem-pro'),
        'desc' => __('client logo for footer', 'groceem-pro'),
        'id' => 'clientlogos',
        'std' => '[clientlogos][logos image="'.get_template_directory_uri().'/images/our-client-1.png" link="#"][logos image="'.get_template_directory_uri().'/images/our-client-2.png" link="#"][logos image="'.get_template_directory_uri().'/images/our-client-3.png" link="#"][logos image="'.get_template_directory_uri().'/images/our-client-4.png" link="#"][logos image="'.get_template_directory_uri().'/images/our-client-5.png" link="#"][/clientlogos]',
        'type' => 'textarea');

    $options[] = array(
        'name' => __('Footer Social Icons', 'groceem-pro'),
        'desc' => __('social icons for footer', 'groceem-pro'),
        'id' => 'footersocialicon',
        'std' => '[social_area]
[social icon="fab fa-facebook-f" link="#"]
[social icon="fab fa-instagram" link="#"]
[social icon="fab fa-twitter" link="#"]
[social icon="fab fa-linkedin-in" link="#"]
[/social_area]',
        'type' => 'textarea');

    $options[] = array(
        'name' => __('Contact Details', 'groceem-pro'),
        'desc' => __('Add Contact Details title here', 'groceem-pro'),
        'id' => 'contacttitle',
        'std' => 'Contact Info',
        'type' => 'text');  
        
    $options[] = array( 
        'desc' => __('Add company address here.', 'groceem-pro'),
        'id' => 'address',
        'std' => '4016 Doane Street, Fremont CA 94538, USA',
        'type' => 'textarea');
        
    $options[] = array(     
        'desc' => __('Add phone number here.', 'groceem-pro'),
        'id' => 'phone',
        'std' => '+1 202 537 0198',
        'type' => 'textarea');

    $options[] = array(
        'desc' => __('Add email address here.', 'groceem-pro'),
        'id' => 'email',
        'std' => 'info@sitename.com',
        'type' => 'textarea');

    $options[] = array(     
        'desc' => __('Add website here.', 'groceem-pro'),
        'id' => 'website',
        'std' => '',
        'type' => 'textarea');  

    $options[] = array(
        'name' => __('Footer Quick Links Title', 'groceem-pro'),
        'desc' => __('footer quick links title.', 'groceem-pro'),
        'id' => 'footermenutitle',
        'std' => 'Categories',
        'type' => 'text');
        
    $options[] = array(
        'name' => __('Footer Services Title', 'groceem-pro'),
        'desc' => __('footer services title.', 'groceem-pro'),
        'id' => 'usefulllinkmenutitle',
        'std' => 'Menu',
        'type' => 'text');
    
    $options[] = array(
        'name' => __('Footer Visas Logos', 'groceem-pro'),
        'desc' => __('Visas logos for footer', 'groceem-pro'),
        'id' => 'visalogo',
        'std' => get_template_directory_uri().'/images/visa-logos.png',
        'type' => 'upload');

    $options[] = array(
        'name' => __('Footer Copyright', 'groceem-pro'),
        'desc' => __('Copyright Text for your site.', 'groceem-pro'),
        'id' => 'copytext',
        'std' => '&copy; Copyright 2023 Groceem. All Rights Reserved',
        'type' => 'textarea');
         
    $options[] = array(
        'desc' => __('Footer Text Link', 'groceem-pro'),
        'id' => 'ftlink',
        'std' => 'Design by <a href="'.esc_url('https://gracethemes.com').'" target="_blank">Grace Themes</a>',
        'type' => 'textarea',);  
        
    $options[] = array(
        'desc' => __('Footer Back to Top Button', 'groceem-pro'),
        'id' => 'backtotop',
        'std' => '[back-to-top]',
        'type' => 'textarea',);

	//Short codes
	$options[] = array(
		'name' => __('Short Codes', 'groceem-pro'),
		'type' => 'heading');
		
	$options[] = array(
		'name' => __('Section Main Title', 'groceem-pro'),
		'desc' => __('[section-main-title title="TITLE HERE" color="#ffffff"]', 'groceem-pro'),
		'type' => 'info');			

	$options[] = array(
		'name' => __('Our Mission Image', 'groceem-pro'),
		'desc' => __('[our-mission-image image="ADD IMAGE URL HERE"]', 'groceem-pro'),
		'type' => 'info');
                		
	$options[] = array(
		'name' => __('Our Mission', 'groceem-pro'),
		'desc' => __('[our-mission icon="ADD IMAGE URL" title="ADD TITLE HERE" description="ADD DESCRIPTION HERE"]', 'groceem-pro'),
		'type' => 'info');
                
    $options[] = array(
        'name' => __('Natural Products Image', 'groceem-pro'),
        'desc' => __('[natural-products-image image="ADD IMAGE URL"]', 'groceem-pro'),
        'type' => 'info');
                
    $options[] = array(
        'name' => __('Organic Fresh Image', 'groceem-pro'),
        'desc' => __('[organic-fresh-image image="ADD IMAGE URL"]', 'groceem-pro'),
        'type' => 'info');

    $options[] = array(
        'name' => __('Organic Fres', 'groceem-pro'),
        'desc' => __('[organic-fres image="ADD IMAGE URL" title="ADD TITLE HERE" description="ADD DESCRIPTION HERE" readmore="READ MORE" link="#"]', 'groceem-pro'),
        'type' => 'info');

    $options[] = array(
        'name' => __('Our Services', 'groceem-pro'),
        'desc' => __('[services icon="ADD IMAGE ICON" title="ADD TITLE HERE" description="ADD DESCRIPTION HERE" link="#"]', 'groceem-pro'),
        'type' => 'info');
		   
  $options[] = array(
        'name' => __('Accredited Farmers', 'groceem-pro'),
        'desc' => __('[accredited-farmers image="ADD IMAGE URL" title="ADD TITLE HERE"]', 'groceem-pro'),
        'type' => 'info');
           
  $options[] = array(
        'name' => __('Accredited Farmers', 'groceem-pro'),
        'desc' => __('[we-believe-farmers-image image_large="ADD IMAGE LARGE" image_thumb="ADD IMAGE thumbnail"]', 'groceem-pro'),
        'type' => 'info');		   
           
  $options[] = array(
        'name' => __('Organic Store', 'groceem-pro'),
        'desc' => __('[organic-store image="ADD IMAGE URL" title="ADD TITLE HERE" discount="30% Discount" shopnow="SHOP NOW" link="#"]', 'groceem-pro'),
        'type' => 'info');  		

    $options[] = array(
        'name' => __('Our Story Image', 'groceem-pro'),
        'desc' => __('[offering-services image="ADD IMAGE URL HERE" icon="ADD ICON HERE" title="ADD TITLE HERE" description="ADD DESCRIPTION HERE" link="#"]', 'groceem-pro'),
        'type' => 'info');	
 
		
	$options[] = array(
        'name' => __('Our Products', 'groceem-pro'),
        'desc' => __('[products limit="4" columns="4" class="our-product"]', 'groceem-pro'),
        'type' => 'info');	 

    $options[] = array(
		'name' => __('Our Team', 'groceem-pro'),
		'desc' => __('[our-team show="4"]', 'groceem-pro'),
		'type' => 'info');	
		
	$options[] = array(
		'name' => __('Testimonials Rotator', 'groceem-pro'),
		'desc' => __('[testimonials]', 'groceem-pro'),
		'type' => 'info');		

	$options[] = array(
		'name' => __('Custom Video', 'groceem-pro'),
		'desc' => __('[custom-video youtubeid="enter here youtube id exa. EQDN49NBXEE" cover="enter here cover photo"]', 'groceem-pro'),
		'type' => 'info');		
    
	$options[] = array(
		'name' => __('Latest News', 'groceem-pro'),
		'desc' => __('[latest-news showposts="3" date="show" comment="hide" author="show"]', 'groceem-pro'),
		'type' => 'info');
    
    $options[] = array(
        'name' => __('Client logos', 'groceem-pro'),
        'desc' => __('[clientlogos][logos image="ADD IMAGE URL" link="#"][/clientlogos]', 'groceem-pro'),
        'type' => 'info');  	

	$options[] = array(
		'name' => __('Custom Button', 'groceem-pro'),
		'desc' => __('[button name="View Gallery" link="#" target=""]', 'groceem-pro'),
		'type' => 'info');		
		
	$options[] = array(
		'name' => __('Search Form', 'groceem-pro'),
		'desc' => __('[searchform]', 'groceem-pro'),
		'type' => 'info');
		
	$options[] = array(
		'name' => __('Social Icons ( Note: More social icons can be found at: https://fontawesome.com/icons)', 'groceem-pro'),
		'desc' => __('[social_area]<br />
			[social icon="fab fa-facebook-f" link="#"]<br />
			[social icon="fab fa-twitter" link="#"]<br />
			[social icon="fab fa-linkedin-in" link="#"]<br />
			[social icon="fab fa-instagram" link="#"]<br />
		[/social_area]', 'groceem-pro'),
		'type' => 'info');	

	$options[] = array(
		'name' => __('2 Column Content', 'groceem-pro'),
		'desc' => __('<pre>
[column_content type="one_half"]
	Column 1 Content goes here...
[/column_content]

[column_content type="one_half_last"]
	Column 2 Content goes here...
[/column_content]
</pre>', 'groceem-pro'),
		'type' => 'info');	

	$options[] = array(
		'name' => __('3 Column Content', 'groceem-pro'),
		'desc' => __('<pre>
[column_content type="one_third"]
	Column 1 Content goes here...
[/column_content]

[column_content type="one_third"]
	Column 2 Content goes here...
[/column_content]

[column_content type="one_third_last"]
	Column 3 Content goes here...
[/column_content]
</pre>', 'groceem-pro'),
		'type' => 'info');	

	$options[] = array(
		'name' => __('4 Column Content', 'groceem-pro'),
		'desc' => __('<pre>
[column_content type="one_fourth"]
	Column 1 Content goes here...
[/column_content]

[column_content type="one_fourth"]
	Column 2 Content goes here...
[/column_content]

[column_content type="one_fourth"]
	Column 3 Content goes here...
[/column_content]

[column_content type="one_fourth_last"]
	Column 4 Content goes here...
[/column_content]
</pre>', 'groceem-pro'),
		'type' => 'info');	

	$options[] = array(
		'name' => __('5 Column Content', 'groceem-pro'),
		'desc' => __('<pre>
[column_content type="one_fifth"]
	Column 1 Content goes here...
[/column_content]

[column_content type="one_fifth"]
	Column 2 Content goes here...
[/column_content]

[column_content type="one_fifth"]
	Column 3 Content goes here...
[/column_content]

[column_content type="one_fifth"]
	Column 4 Content goes here...
[/column_content]

[column_content type="one_fifth_last"]
	Column 5 Content goes here...
[/column_content]
</pre>', 'groceem-pro'),
		'type' => 'info');	

	$options[] = array(
		'name' => __('Tabs', 'groceem-pro'),
		'desc' => __('<pre>
[tabs]
	[tab title="TAB TITLE 1"]
		TAB CONTENT 1
	[/tab]
	[tab title="TAB TITLE 2"]
		TAB CONTENT 2
	[/tab]
	[tab title="TAB TITLE 3"]
		TAB CONTENT 3
	[/tab]
[/tabs]
</pre>', 'groceem-pro'),
		'type' => 'info');


	$options[] = array(
		'name' => __('Toggle Content', 'groceem-pro'),
		'desc' => __('<pre>
[toggle_content title="Toggle Title 1"]
	Toggle content 1...
[/toggle_content]
[toggle_content title="Toggle Title 2"]
	Toggle content 2...
[/toggle_content]
[toggle_content title="Toggle Title 3"]
	Toggle content 3...
[/toggle_content]
</pre>', 'groceem-pro'),
		'type' => 'info');


		
	$options[] = array(
		'name' => __('Clear', 'groceem-pro'),
		'desc' => __('<pre>
[clear]
</pre>', 'groceem-pro'),
		'type' => 'info');	

	$options[] = array(
		'name' => __('HR / Horizontal separation line', 'groceem-pro'),
		'desc' => __('<pre>
[hr] or &lt;hr&gt;
</pre>', 'groceem-pro'),
		'type' => 'info');
		
	$options[] = array(
		'name' => __('Subtitle', 'groceem-pro'),
		'desc' => __('[subtitle color="#111111" description="short descriptio here"]', 'groceem-pro'),
		'type' => 'info');	
	
	$options[] = array(
		'name' => __('Scroll to Top', 'groceem-pro'),
		'desc' => __('[back-to-top] 
', 'groceem-pro'),
		'type' => 'info');

	return $options;
}